/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IPerspectiveModelListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.PerspectiveType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.EnumMap;
import java.util.Map;

public final class CPerspectiveModel {
    private final ListenerProvider<IPerspectiveModelListener> m_listeners = new ListenerProvider();
    private final Map<PerspectiveType, Object> m_models = new EnumMap<PerspectiveType, Object>(PerspectiveType.class);

    public CPerspectiveModel(IGraphModel model) {
        this.m_models.put(PerspectiveType.DebugPerspective, new CDebugPerspectiveModel(model));
    }

    public void addListener(IPerspectiveModelListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Object getModel(PerspectiveType type) {
        Preconditions.checkNotNull(type, "IE01805: Type argument can not be null");
        return this.m_models.get((Object)type);
    }

    public void removeListener(IPerspectiveModelListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setActiveView(PerspectiveType activeView) {
        Preconditions.checkNotNull(activeView, "IE01806: Active view argument can not be null");
        for (IPerspectiveModelListener listener : this.m_listeners) {
            try {
                listener.changedActivePerspective(activeView);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

