/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTaggedNodesContainerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTreeModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CAbstractTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodeNode;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.Filter.CGraphNodeTaggedFilter;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviGraphListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

public final class CTaggedGraphNodesContainerNode
extends CAbstractTagTreeNode {
    private static final long serialVersionUID = -4590660106065351427L;
    private static final ImageIcon ICON_ALL_UNSELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected.png"));
    private static final ImageIcon ICON_ALL_SELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_open.png"));
    private static final ImageIcon ICON_ALL_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected_gray.png"));
    private static final ImageIcon ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_all_unselected_halfgray.png"));
    private static final ImageIcon ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_some_unselected.png"));
    private static final ImageIcon ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_some_unselected_halfgray.png"));
    private static final ImageIcon ICON_EMPTY_FOLDER = new ImageIcon(CMain.class.getResource("data/undoselectionchoosericons/graph_selection_folder_empty.png"));
    private final CTagsTreeModel m_model;
    private final ITreeNode<CTag> m_tag;
    private final CTaggedNodesContainerNodeMenuBuilder m_menuBuilder;
    private final InternalNaviGraphListener m_graphListener = new InternalNaviGraphListener();
    private final InternalViewListener m_viewListener = new InternalViewListener();

    public CTaggedGraphNodesContainerNode(ZyGraph graph, CTagsTreeModel model, ITreeNode<CTag> tag) {
        super(-tag.getObject().getId(), graph);
        Preconditions.checkNotNull(graph, "IE01800: Graph can not be null.");
        this.m_model = Preconditions.checkNotNull(model, "IE01801: Model can not be null.");
        this.m_tag = Preconditions.checkNotNull(tag, "IE02327: Tag argument can not be null");
        this.m_menuBuilder = new CTaggedNodesContainerNodeMenuBuilder(graph, this.m_tag);
        this.createChildren();
        graph.addListener(this.m_graphListener);
        graph.getRawView().addListener(this.m_viewListener);
    }

    private void createChildren() {
        List<NaviNode> nodes = GraphHelpers.filter(this.getGraph(), new CGraphNodeTaggedFilter(Sets.newHashSet(this.m_tag.getObject())));
        for (NaviNode node : nodes) {
            this.add(new CTaggedGraphNodeNode(this.getGraph(), node));
        }
    }

    @Override
    public void dispose() {
        this.getGraph().getRawView().removeListener(this.m_viewListener);
        this.getGraph().removeListener(this.m_graphListener);
    }

    public List<NaviNode> getGraphNodes() {
        ArrayList<NaviNode> graphNode = new ArrayList<NaviNode>();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            graphNode.add(((CTaggedGraphNodeNode)enumeration.nextElement()).getGraphNode());
        }
        return graphNode;
    }

    @Override
    public Icon getIcon() {
        int selected = 0;
        int unselected = 0;
        int invisible = 0;
        List<NaviNode> nodes = this.getGraphNodes();
        for (NaviNode n2 : nodes) {
            if (n2.getRawNode().isSelected()) {
                ++selected;
            } else {
                ++unselected;
            }
            if (n2.getRawNode().isVisible()) continue;
            ++invisible;
        }
        if (nodes.isEmpty()) {
            return ICON_EMPTY_FOLDER;
        }
        if (invisible == nodes.size()) {
            return ICON_ALL_INVISIBLE_GRAPHNODES;
        }
        if (selected == nodes.size()) {
            return ICON_ALL_SELECTED_GRAPHNODES;
        }
        if (unselected == nodes.size() && invisible == 0) {
            return ICON_ALL_UNSELECTED_GRAPHNODES;
        }
        if (selected == 0) {
            return ICON_ALL_UNSELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        if (invisible == 0) {
            return ICON_ALL_VISIBLE_SOME_SELECTED_SOME_UNSELECTED_GRAPHNODES;
        }
        if (invisible != 0 && selected != 0) {
            return ICON_SOME_SELECTED_SOME_VISIBLE_SOME_INVISIBLE_GRAPHNODES;
        }
        throw new IllegalStateException("IE00669: Unknown container state");
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.m_menuBuilder.getPopupMenu();
    }

    @Override
    public ITreeNode<CTag> getTag() {
        return this.m_tag;
    }

    @Override
    public String toString() {
        int selected = 0;
        int visible = 0;
        int invisible = 0;
        for (NaviNode n2 : this.getGraphNodes()) {
            if (n2.getRawNode().isSelected()) {
                ++selected;
            }
            if (n2.getRawNode().isVisible()) {
                ++visible;
                continue;
            }
            ++invisible;
        }
        return String.format("Tagged Nodes (%d/%d/%d/%d)", selected, visible, invisible, visible + invisible);
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        private void deleteNode(INaviViewNode node) {
            for (int i2 = 0; i2 < CTaggedGraphNodesContainerNode.this.getChildCount(); ++i2) {
                if (((CTaggedGraphNodeNode)CTaggedGraphNodesContainerNode.this.getChildAt(i2)).getGraphNode().getRawNode() != node) continue;
                CTaggedGraphNodesContainerNode.this.remove(i2);
                break;
            }
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            this.deleteNode(node);
            CTaggedGraphNodesContainerNode.this.m_model.nodeStructureChanged(CTaggedGraphNodesContainerNode.this.m_model.getRoot());
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            for (INaviViewNode node : nodes) {
                this.deleteNode(node);
            }
            CTaggedGraphNodesContainerNode.this.m_model.nodeStructureChanged(CTaggedGraphNodesContainerNode.this.m_model.getRoot());
        }
    }

    private class InternalNaviGraphListener
    extends NaviGraphListenerAdapter {
        private InternalNaviGraphListener() {
        }

        @Override
        public void addedNode(ZyGraph graph, NaviNode node) {
            CGraphNodeTaggedFilter filter = new CGraphNodeTaggedFilter(Sets.newHashSet((CTag)CTaggedGraphNodesContainerNode.this.m_tag.getObject()));
            if (filter.qualifies(node)) {
                CTaggedGraphNodesContainerNode.this.add(new CTaggedGraphNodeNode(CTaggedGraphNodesContainerNode.this.getGraph(), node));
                CTaggedGraphNodesContainerNode.this.m_model.nodeStructureChanged(CTaggedGraphNodesContainerNode.this.m_model.getRoot());
            }
        }

        @Override
        public void changedView(INaviView oldView, INaviView newView) {
            oldView.removeListener(CTaggedGraphNodesContainerNode.this.m_viewListener);
            newView.addListener(CTaggedGraphNodesContainerNode.this.m_viewListener);
        }

        @Override
        public void taggedNode(INaviView view, INaviViewNode node, CTag tag) {
            if (CTaggedGraphNodesContainerNode.this.m_tag.getObject() == tag) {
                CTaggedGraphNodesContainerNode.this.m_model.getRoot().addGraphNodeNodeToTree(node, CTaggedGraphNodesContainerNode.this);
                CTaggedGraphNodesContainerNode.this.m_model.nodeStructureChanged(CTaggedGraphNodesContainerNode.this.m_model.getRoot());
            }
        }

        @Override
        public void untaggedNode(INaviView view, INaviViewNode node, CTag tag) {
            if (CTaggedGraphNodesContainerNode.this.m_tag.getObject() == tag) {
                CTaggedGraphNodesContainerNode.this.m_model.getRoot().refreshTree(CTaggedGraphNodesContainerNode.this.m_tag);
                CTaggedGraphNodesContainerNode.this.m_model.nodeStructureChanged(CTaggedGraphNodesContainerNode.this.parent);
            }
        }
    }
}

