/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagTreeNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTreeModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CAbstractTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodesContainerNode;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeTaggingTree.Nodes.CRootTagTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

public final class CTagTreeNode
extends CAbstractTagTreeNode {
    private static final long serialVersionUID = -274077764881287409L;
    private static final ImageIcon ICON_GREEN_TAG = new ImageIcon(CMain.class.getResource("data/nodetaggingtreeicons/green_tag.png"));
    private static final ImageIcon ICON_GREEN_ROOTTAG = new ImageIcon(CMain.class.getResource("data/nodetaggingtreeicons/green_roottag.png"));
    private final JFrame m_parent;
    private final ITagManager m_tagManager;
    private final CTagsTreeModel m_model;
    private final ITreeNode<CTag> m_tag;
    private final CTagTreeNodeMenuBuilder m_menuBuilder;
    private final InternalTagManagerListener m_tagManagerListener = new InternalTagManagerListener();
    private final InternalTagListener m_tagListener = new InternalTagListener();

    public CTagTreeNode(JFrame parent, ZyGraph graph, ITagManager tagManager, CTagsTreeModel model, ITreeNode<CTag> tag) {
        super(tag.getObject().getId(), graph);
        this.m_parent = Preconditions.checkNotNull(parent, "IE02328: Parent argument can not be null");
        this.m_tag = Preconditions.checkNotNull(tag, "IE02329: Tag argument can not be null");
        this.m_tagManager = Preconditions.checkNotNull(tagManager, "IE01802: Tag manager can not be null");
        this.m_model = Preconditions.checkNotNull(model, "IE01803: Treemodel can't be null.");
        this.m_menuBuilder = new CTagTreeNodeMenuBuilder(parent, graph, tagManager, this.m_tag);
        this.m_tagManager.addListener(this.m_tagManagerListener);
        this.m_tag.getObject().addListener(this.m_tagListener);
        this.createChildren();
    }

    private void createChildren() {
        this.add(new CTaggedGraphNodesContainerNode(this.getGraph(), this.m_model, this.m_tag));
        for (ITreeNode<CTag> child : this.m_tag.getChildren()) {
            this.add(new CTagTreeNode(this.m_parent, this.getGraph(), this.m_tagManager, this.m_model, child));
        }
    }

    private int getDeepChildCount() {
        int count = 0;
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof CTagTreeNode)) continue;
            ++count;
        }
        return count == 0 ? 0 : count - 1;
    }

    private boolean isRootTag() {
        return this.m_model.getPathToRoot(this).length == 2;
    }

    @Override
    public void dispose() {
        this.m_tagManager.removeListener(this.m_tagManagerListener);
        this.m_tag.getObject().removeListener(this.m_tagListener);
        this.deleteChildren();
    }

    @Override
    public Icon getIcon() {
        return this.isRootTag() ? ICON_GREEN_ROOTTAG : ICON_GREEN_TAG;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.m_menuBuilder.getPopupMenu();
    }

    @Override
    public ITreeNode<CTag> getTag() {
        return this.m_tag;
    }

    public ITagManager getTagManager() {
        return this.m_tagManager;
    }

    @Override
    public String toString() {
        return String.format("%s (%s/%s)", this.m_tag.getObject().getName(), this.getChildCount() - 1, this.getDeepChildCount());
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            if (((CTag)CTagTreeNode.this.m_tag.getObject()).getId() == tag.getParent().getObject().getId()) {
                ((CRootTagTreeNode)CTagTreeNode.this.getRoot()).refreshTree(tag);
                CTagTreeNode.this.m_model.nodeStructureChanged(CTagTreeNode.this);
            }
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (((CTag)CTagTreeNode.this.m_tag.getObject()).getId() == parent.getObject().getId()) {
                ((CRootTagTreeNode)CTagTreeNode.this.getRoot()).refreshTree(parent);
                CTagTreeNode.this.m_model.nodeStructureChanged(CTagTreeNode.this.getRoot());
            }
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (((CTag)CTagTreeNode.this.m_tag.getObject()).getId() == parent.getObject().getId()) {
                ((CRootTagTreeNode)CTagTreeNode.this.getRoot()).refreshTree(parent);
                CTagTreeNode.this.m_model.nodeStructureChanged(CTagTreeNode.this.getRoot());
            }
        }

        @Override
        public void insertedTag(CTagManager tagManager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            if (((CTag)CTagTreeNode.this.m_tag.getObject()).getId() == tag.getParent().getObject().getId()) {
                ((CRootTagTreeNode)CTagTreeNode.this.getRoot()).refreshTree(tag);
                CTagTreeNode.this.m_model.nodeStructureChanged(CTagTreeNode.this.getRoot());
            }
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
        }

        @Override
        public void changedName(CTag tag, String name) {
            CTagTreeNode.this.m_model.nodeChanged(CTagTreeNode.this);
        }

        @Override
        public void deletedTag(CTag tag) {
        }
    }
}

