/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class CTaggingFunctions {
    private CTaggingFunctions() {
    }

    public static CTag getSelectedTag(JTree tagsTree) throws MaybeNullException {
        TreePath selectionPath = tagsTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof CTagTreeNode && selectionPath.getLastPathComponent() instanceof CTagTreeNode) {
            CTagTreeNode ttn = (CTagTreeNode)selectionPath.getLastPathComponent();
            return ttn.getTag().getObject();
        }
        throw new MaybeNullException();
    }

    public static void tagNode(JFrame parent, NaviNode node, CTag tag) {
        try {
            node.getRawNode().tagNode(tag);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00131: Could not tag node";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The selected node could not be tagged with the tag '%s'.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The node remains untagged."});
            NaviErrorDialog.show(parent, "E00131: Could not tag node", innerDescription, e2);
        }
    }

    public static void tagNode(JFrame parent, JTree tagsTree, NaviNode node) {
        try {
            CTaggingFunctions.tagNode(parent, node, CTaggingFunctions.getSelectedTag(tagsTree));
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }

    public static void tagSelectedNodes(JFrame parent, JTree tagsTree, ZyGraph graph) {
        try {
            CTaggingFunctions.tagSelectedNodes(parent, graph, CTaggingFunctions.getSelectedTag(tagsTree));
        }
        catch (MaybeNullException maybeNullException) {
            // empty catch block
        }
    }

    public static void tagSelectedNodes(JFrame parent, ZyGraph graph, CTag tag) {
        Set<NaviNode> selectedNodes = graph.getSelectedNodes();
        try {
            for (NaviNode node : selectedNodes) {
                node.getRawNode().tagNode(tag);
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00134: Could not tag selected nodes";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The selected nodes could not be tagged with the tag '%s'.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"Some nodes were tagged while other remain untagged."});
            NaviErrorDialog.show(parent, "E00134: Could not tag selected nodes", innerDescription, e2);
        }
    }
}

