/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations;

import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.Filter.CGraphNodeTaggedAndVisibleFilter;
import com.google.security.zynamics.binnavi.ZyGraph.Filter.CGraphNodeTaggedFilter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.trees.BreadthFirstSorter;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CTagSelectionFunctions {
    private CTagSelectionFunctions() {
    }

    private static Set<CTag> getSubtreeTags(ITreeNode<CTag> tag) {
        HashSet<CTag> tags = new HashSet<CTag>();
        tags.add(tag.getObject());
        for (ITreeNode<CTag> t2 : BreadthFirstSorter.getSortedList(tag)) {
            tags.add(t2.getObject());
        }
        return tags;
    }

    private static void selectNodes(ZyGraph graph, Set<CTag> tags, boolean mustBeVisible) {
        List<NaviNode> nodes = mustBeVisible ? GraphHelpers.filter(graph, new CGraphNodeTaggedFilter(tags)) : GraphHelpers.filter(graph, new CGraphNodeTaggedAndVisibleFilter(tags));
        graph.selectNodes(nodes, true);
    }

    private static void unselectNodes(ZyGraph graph, Set<CTag> tags, boolean mustBeVisible) {
        List<NaviNode> nodes = mustBeVisible ? GraphHelpers.filter(graph, new CGraphNodeTaggedFilter(tags)) : GraphHelpers.filter(graph, new CGraphNodeTaggedAndVisibleFilter(tags));
        graph.selectNodes(nodes, false);
    }

    public static void selectNodes(ZyGraph graph, CTag tag) {
        CTagSelectionFunctions.selectNodes(graph, Sets.newHashSet(tag), false);
    }

    public static void selectSubtreeNodes(ZyGraph graph, ITreeNode<CTag> tag) {
        CTagSelectionFunctions.selectNodes(graph, CTagSelectionFunctions.getSubtreeTags(tag), false);
    }

    public static void selectVisibleNodes(ZyGraph graph, CTag tag) {
        CTagSelectionFunctions.selectNodes(graph, Sets.newHashSet(tag), true);
    }

    public static void selectVisibleSubtreeNodes(ZyGraph graph, ITreeNode<CTag> tag) {
        CTagSelectionFunctions.selectNodes(graph, CTagSelectionFunctions.getSubtreeTags(tag), true);
    }

    public static void unselectNodes(ZyGraph graph, CTag tag) {
        CTagSelectionFunctions.unselectNodes(graph, Sets.newHashSet(tag), true);
    }

    public static void unselectSubtreeNodes(ZyGraph graph, ITreeNode<CTag> tag) {
        CTagSelectionFunctions.unselectNodes(graph, CTagSelectionFunctions.getSubtreeTags(tag), true);
    }
}

