/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CViewCommentDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.awt.Window;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public final class CTagFunctions {
    private CTagFunctions() {
    }

    public static void appendTag(JFrame parent, ITagManager tagManager, ITreeNode<CTag> parentTag) {
        try {
            tagManager.addTag(parentTag, parentTag.getObject().getId() == 0 ? "New Root Tag" : "New Child Tag");
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00135: Could not append tag";
            String innerDescription = CUtilityFunctions.createDescription(String.format("It was not possible to append a tag to the tag '%s'.", parentTag.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag can not be appended."});
            NaviErrorDialog.show(parent, "E00135: Could not append tag", innerDescription, e2);
        }
    }

    public static void deleteTag(JFrame parent, ITagManager tagManager, ITreeNode<CTag> tag) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to convert delete the node tag '%s'?", tag.getObject().getName())) == 0) {
            try {
                tagManager.deleteTag(tag);
            }
            catch (CouldntDeleteException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00124: Could not delete tag";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' could not be deleted.", tag.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag still exists."});
                NaviErrorDialog.show(parent, "E00124: Could not delete tag", innerDescription, e2);
            }
        }
    }

    public static void deleteTagSubTree(JFrame parent, ITagManager tagManager, ITreeNode<CTag> tag) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to convert delete the node tag '%s' and all of its children?", tag.getObject().getName())) == 0) {
            try {
                tagManager.deleteTagSubTree(tag);
            }
            catch (CouldntDeleteException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00125: Could not delete tags";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' and its children could not be deleted.", tag.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag and its children still exist."});
                NaviErrorDialog.show(parent, "E00125: Could not delete tags", innerDescription, e2);
            }
        }
    }

    public static void editTag(JFrame parent, CTag tag) {
        CViewCommentDialog dlg = new CViewCommentDialog((Window)parent, "Edit Tag", tag.getName(), tag.getDescription());
        dlg.setVisible(true);
        if (!dlg.wasCancelled()) {
            String innerDescription;
            String innerMessage;
            try {
                tag.setName(dlg.getName());
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                innerMessage = "E00126: Could not change tag name";
                innerDescription = CUtilityFunctions.createDescription(String.format("The name of the tag '%s' could not be changed.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag name could not be changed."});
                NaviErrorDialog.show(parent, "E00126: Could not change tag name", innerDescription, e2);
            }
            try {
                tag.setDescription(dlg.getComment());
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                innerMessage = "E00127: Could not change tag description";
                innerDescription = CUtilityFunctions.createDescription(String.format("The description of the tag '%s' could not be changed.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag description could not be changed."});
                NaviErrorDialog.show(parent, "E00127: Could not change tag description", innerDescription, e3);
            }
        }
    }

    public static void insertTag(JFrame parent, ITagManager tagManager, ITreeNode<CTag> parentTag) {
        try {
            tagManager.insertTag(parentTag, "New Tag Node");
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00128: Could not insert tag";
            String innerDescription = CUtilityFunctions.createDescription(String.format("It was not possible to insert a tag between the tag '%s' and its children.", parentTag.getObject().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The new tag could not be inserted."});
            NaviErrorDialog.show(parent, "E00128: Could not insert tag", innerDescription, e2);
        }
    }

    public static void removeTagFromAllNodes(JFrame parent, ZyGraph graph, CTag tag) {
        List<NaviNode> nodes = GraphHelpers.getNodes(graph);
        try {
            for (NaviNode n2 : nodes) {
                n2.getRawNode().removeTag(tag);
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00129: Could not remove tag from nodes";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' could not be appended from all nodes.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag was removed from some nodes but not from all."});
            NaviErrorDialog.show(parent, "E00129: Could not remove tag from nodes", innerDescription, e2);
        }
    }

    public static void removeTagFromSelectedNodes(JFrame parent, ZyGraph graph, CTag tag) {
        Set<NaviNode> nodes = graph.getSelectedNodes();
        try {
            for (NaviNode n2 : nodes) {
                n2.getRawNode().removeTag(tag);
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00130: Could not remove tag from nodes";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' could not be removed from the selected nodes.", tag.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag was removed from some nodes but not from all."});
            NaviErrorDialog.show(parent, "E00130: Could not remove tag from nodes", innerDescription, e2);
        }
    }
}

