/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodesContainerNode;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CNodesDisplayString;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.jtree.IconNodeRenderer;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.HtmlGenerator;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CTagTreeCellRenderer
extends IconNodeRenderer {
    private static final long serialVersionUID = -2003280754368848624L;
    private static final Color DEFAULT_FOREGROUND_COLOR = new Color(0, 0, 0);
    private static final Color COLOR_TAGGED_SELECTED_ALL = new Color(160, 0, 0);
    private static final Color COLOR_TAGGED_SELECTED_ANY = new Color(160, 120, 120);
    private static final Color COLOR_TAGGED_INVISIBLE = new Color(128, 128, 128);
    private DefaultMutableTreeNode m_lastSelectionNode = null;

    private String buildToolTip(NaviNode node) {
        ZyLabelContent content = node.getRealizer().getNodeContent();
        return HtmlGenerator.getHtml(content, GuiHelper.getMonospaceFont(), true);
    }

    private String buildToolTip(CTag tag) {
        String string2 = tag.getName();
        String string3 = String.valueOf(tag.getDescription().replace("\n", "<br>"));
        return new StringBuilder(31 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("<html><b>").append(string2).append("</b><br><i>").append(string3).append("</i></html>").toString();
    }

    private String buildToolTip(CTaggedGraphNodesContainerNode node) {
        StringBuilder tooltip = new StringBuilder("<html>");
        boolean first = true;
        for (NaviNode graphnode : node.getGraphNodes()) {
            if (!first) {
                tooltip.append("<br>");
            }
            tooltip.append(CNodesDisplayString.getDisplayString(graphnode));
            first = false;
        }
        String string2 = String.valueOf(tooltip);
        return new StringBuilder(7 + String.valueOf(string2).length()).append(string2).append("</html>").toString();
    }

    private boolean isAllTaggedAndInvisible(List<NaviNode> graphNodes) {
        return CollectionHelpers.all(graphNodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return item.getRawNode().isTagged() && !item.getRawNode().isVisible();
            }
        });
    }

    private boolean isAllTaggedAndSelected(List<NaviNode> graphNodes) {
        return CollectionHelpers.all(graphNodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return item.getRawNode().isTagged() && item.getRawNode().isSelected();
            }
        });
    }

    private boolean isAnyTaggedAndSelected(List<NaviNode> graphNodes) {
        return CollectionHelpers.any(graphNodes, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return item.getRawNode().isTagged() && item.getRawNode().isSelected();
            }
        });
    }

    private void renderTaggedGraphNodeNode(CTaggedGraphNodeNode node) {
        INaviViewNode rawNode = node.getGraphNode().getRawNode();
        if (rawNode.isTagged() && rawNode.isSelected()) {
            this.setForeground(COLOR_TAGGED_SELECTED_ALL);
        } else if (rawNode.isTagged() && !rawNode.isVisible()) {
            this.setForeground(COLOR_TAGGED_INVISIBLE);
        }
        this.setToolTipText(this.buildToolTip(node.getGraphNode()));
    }

    private void renderTaggedGraphNodesContainerNode(CTaggedGraphNodesContainerNode node) {
        List<NaviNode> graphNodes = node.getGraphNodes();
        if (!graphNodes.isEmpty()) {
            if (this.isAllTaggedAndSelected(graphNodes)) {
                this.setForeground(COLOR_TAGGED_SELECTED_ALL);
            } else if (this.isAnyTaggedAndSelected(graphNodes)) {
                this.setForeground(COLOR_TAGGED_SELECTED_ANY);
            } else if (this.isAllTaggedAndInvisible(graphNodes)) {
                this.setForeground(COLOR_TAGGED_INVISIBLE);
            }
            this.setToolTipText(this.buildToolTip(node));
        }
    }

    private void renderTagTreeNode(CTagTreeNode node) {
        CTag tag = node.getTag().getObject();
        this.setToolTipText(this.buildToolTip(tag));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean selected = this.m_lastSelectionNode != null && ((DefaultMutableTreeNode)value).getUserObject() == this.m_lastSelectionNode.getUserObject();
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, selected);
        this.setForeground(DEFAULT_FOREGROUND_COLOR);
        if (value instanceof CTagTreeNode) {
            this.renderTagTreeNode((CTagTreeNode)value);
        } else if (value instanceof CTaggedGraphNodeNode) {
            this.renderTaggedGraphNodeNode((CTaggedGraphNodeNode)value);
        } else if (value instanceof CTaggedGraphNodesContainerNode) {
            this.renderTaggedGraphNodesContainerNode((CTaggedGraphNodesContainerNode)value);
        }
        return this;
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        this.m_lastSelectionNode = node;
    }
}

