/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu;

import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Cache.CCriteriumCache;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Cache.ICriteriumCacheListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionExpandSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionExpandSelectionDown;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionExpandSelectionUp;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionInvertSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionRedoSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectByCriteria;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectChildren;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectParents;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShrinkSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShrinkSelectionDown;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionShrinkSelectionUp;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionUndoSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CExecuteCachedCriterium;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CGroupAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CToggleSelectedGroupsAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CUngroupSelectedGroupsAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class CSelectionMenu
extends JMenu {
    private final JMenu m_previousCriteriaMenu = new JMenu("Previous Criteria");
    private final CGraphModel m_model;
    private static final long serialVersionUID = 2997329400894556417L;
    private final CCriteriumCache m_criteriumCache = new CCriteriumCache();
    private final ICriteriumCacheListener m_criteriumCacheListener = new ICriteriumCacheListener(){

        @Override
        public void changedCriteria(CCriteriumCache criteriumCache) {
            CSelectionMenu.this.rebuildCriteriumCacheMenu();
        }
    };

    public CSelectionMenu(CGraphModel model) {
        super("Selection");
        this.m_model = model;
        this.setMnemonic("HK_MENU_SELECTION".charAt(0));
        this.add(CActionProxy.proxy(new CActionUndoSelection(model.getSelectionHistory())));
        this.add(CActionProxy.proxy(new CActionRedoSelection(model.getSelectionHistory())));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CGroupAction(model.getGraph())));
        this.add(CActionProxy.proxy(new CUngroupSelectedGroupsAction(model.getGraph())));
        this.add(CActionProxy.proxy(new CToggleSelectedGroupsAction(model.getGraph())));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionSelectChildren(model.getGraph(), false)));
        this.add(CActionProxy.proxy(new CActionSelectParents(model.getGraph(), false)));
        this.add(CActionProxy.proxy(new CActionInvertSelection(model.getGraph(), false)));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionExpandSelectionDown(model.getGraph())));
        this.add(CActionProxy.proxy(new CActionExpandSelectionUp(model.getGraph())));
        this.add(CActionProxy.proxy(new CActionExpandSelection(model.getGraph())));
        this.add(CActionProxy.proxy(new CActionShrinkSelectionDown(model.getGraph())));
        this.add(CActionProxy.proxy(new CActionShrinkSelectionUp(model.getGraph())));
        this.add(CActionProxy.proxy(new CActionShrinkSelection(model.getGraph())));
        this.addSeparator();
        this.add(CActionProxy.proxy(new CActionSelectByCriteria(model.getGraphPanel(), false)));
        this.add(this.m_previousCriteriaMenu);
        this.m_previousCriteriaMenu.setVisible(false);
        this.m_criteriumCache.addListener(this.m_criteriumCacheListener);
    }

    private void rebuildCriteriumCacheMenu() {
        this.m_previousCriteriaMenu.removeAll();
        this.m_previousCriteriaMenu.setVisible(true);
        for (CCachedExpressionTree tree : this.m_criteriumCache.getTrees()) {
            this.m_previousCriteriaMenu.add(new JMenuItem(new CExecuteCachedCriterium(this.m_model.getGraph(), tree)));
        }
    }

    public void dispose() {
        this.m_criteriumCache.removeListener(this.m_criteriumCacheListener);
    }

    public CCriteriumCache getCriteriumCache() {
        return this.m_criteriumCache;
    }
}

