/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu;

import com.google.security.zynamics.binnavi.API.plugins.IGraphMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.IPluginInterfaceListener;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionGraphScripting;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionOpenLogConsole;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;

public final class CPluginsMenu
extends JMenu {
    private static final long serialVersionUID = 1418451269354925733L;
    private final IPluginInterfaceListener m_listener = new InternalPluginInterfaceListener();
    private final CGraphModel m_model;

    public CPluginsMenu(CGraphModel model) {
        super("Plugins");
        this.m_model = model;
        this.setMnemonic("HK_MENU_PLUGINS".charAt(0));
        this.fillPluginsMenu();
        PluginInterface.instance().addListener(this.m_listener);
    }

    private void extendPluginMenu(IGraphMenuPlugin plugin) {
        try {
            List<JComponent> menuItems = plugin.extendPluginMenu(this.m_model.getGraphFrame());
            if (menuItems != null) {
                for (JComponent menuItem : menuItems) {
                    this.add(menuItem);
                }
            }
        }
        catch (Exception exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00085: Plugin caused an unexpected exception";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
            NaviErrorDialog.show(this.m_model.getParent(), "E00085: Plugin caused an unexpected exception", innerDescription, exception);
        }
    }

    private void fillPluginsMenu() {
        ArrayList<IGraphMenuPlugin> plugins = new ArrayList<IGraphMenuPlugin>();
        for (IGraphMenuPlugin plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IGraphMenuPlugin)) continue;
            plugins.add(plugin);
        }
        this.add(CActionProxy.proxy(new CActionGraphScripting(this.m_model.getGraphPanel())));
        this.add(CActionProxy.proxy(new CActionOpenLogConsole()));
        this.addSeparator();
        for (IGraphMenuPlugin plugin : plugins) {
            this.extendPluginMenu(plugin);
        }
    }

    private void resetPluginsMenu() {
        this.removeAll();
        this.fillPluginsMenu();
    }

    public void dispose() {
        PluginInterface.instance().removeListener(this.m_listener);
    }

    private class InternalPluginInterfaceListener
    implements IPluginInterfaceListener {
        private InternalPluginInterfaceListener() {
        }

        @Override
        public void loadedPlugins() {
            CPluginsMenu.this.resetPluginsMenu();
        }
    }
}

