/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.API.plugins.IGraphMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Cache.CCriteriumCache;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionAutomaticLayouting;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionProximityBrowsing;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSave;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindowMenuBarSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IViewSwitcher;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CGraphMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CPluginsMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CSearchMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CSelectionMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CViewMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CWindowsMenu;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;

public final class CGraphWindowMenuBar
extends JMenuBar {
    private final CGraphModel m_model;
    private final CActionSave m_actionSave;
    private final CGraphWindowMenuBarSynchronizer m_synchronizer;
    private final CSelectionMenu m_selectionMenu;
    private final CPluginsMenu m_pluginsMenu;

    public CGraphWindowMenuBar(CGraphModel model, IViewSwitcher viewSwitcher) {
        Preconditions.checkNotNull(model, "IE01626: Model argument can not be null");
        this.m_model = model;
        this.m_actionSave = new CActionSave(model.getParent(), model.getGraph());
        JCheckBoxMenuItem autoLayoutMenu = new JCheckBoxMenuItem(new CActionAutomaticLayouting(model.getGraph()));
        JCheckBoxMenuItem proximityBrowsingMenu = new JCheckBoxMenuItem(CActionProxy.proxy(new CActionProximityBrowsing(model.getParent(), model.getGraph())));
        this.add(new CViewMenu(model.getParent(), model.getGraphPanel(), model.getGraph(), model.getViewContainer(), this.m_actionSave));
        this.add(new CGraphMenu(model.getParent(), model.getGraph(), model.getViewContainer(), proximityBrowsingMenu, autoLayoutMenu));
        this.m_selectionMenu = new CSelectionMenu(model);
        this.add(this.m_selectionMenu);
        this.add(new CSearchMenu(model.getGraph()));
        this.m_pluginsMenu = new CPluginsMenu(model);
        this.add(this.m_pluginsMenu);
        this.add(new CWindowsMenu(model.getParent(), viewSwitcher));
        this.m_synchronizer = new CGraphWindowMenuBarSynchronizer(model.getGraph().getSettings(), proximityBrowsingMenu, autoLayoutMenu);
        this.updateGui();
    }

    public void dipose() {
        this.m_synchronizer.dispose();
        this.m_selectionMenu.dispose();
        ArrayList<IGraphMenuPlugin> plugins = Lists.newArrayList();
        for (IGraphMenuPlugin plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IGraphMenuPlugin)) continue;
            plugins.add(plugin);
        }
        for (IGraphMenuPlugin plugin : plugins) {
            try {
                plugin.closed(this.m_model.getGraphFrame());
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                String innerMessage = "E00106: Plugin caused an unexpected exception";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
                NaviErrorDialog.show(this.m_model.getParent(), "E00106: Plugin caused an unexpected exception", innerDescription, exception);
            }
        }
        this.m_pluginsMenu.dispose();
    }

    public CCriteriumCache getCriteriumCache() {
        return this.m_selectionMenu.getCriteriumCache();
    }

    public void updateGui() {
        this.m_actionSave.setEnabled(this.m_model.getGraph().getRawView().getType() == ViewType.NonNative);
    }
}

