/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader.IParser;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.CircularStyle;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicStyle;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalStyle;
import java.text.ParseException;
import java.util.Map;

public final class CViewSettingsGenerator {
    private CViewSettingsGenerator() {
    }

    private static boolean createBooleanSetting(Map<String, String> rawSettings, String settingName, boolean defaultValue) {
        String settingString = rawSettings.get(settingName);
        if (settingString == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(settingString);
        }
        catch (NumberFormatException exception) {
            CUtilityFunctions.logException(exception);
            return defaultValue;
        }
    }

    private static <T> T createEnumerationSetting(Map<String, String> rawSettings, String settingName, T defaultValue, IParser<T> parser2) {
        String settingString = rawSettings.get(settingName);
        if (settingString != null && Convert.isDecString(settingString)) {
            try {
                return parser2.parse(Integer.parseInt(settingString));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static double createDoubleSetting(Map<String, String> rawSettings, String settingName, double defaultValue) {
        String settingString = rawSettings.get(settingName);
        if (settingString == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(settingString);
        }
        catch (NumberFormatException exception) {
            CUtilityFunctions.logException(exception);
            return defaultValue;
        }
    }

    public static int createIntegerSetting(Map<String, String> rawSettings, String settingName, int defaultValue) {
        String settingString = rawSettings.get(settingName);
        if (settingString != null && Convert.isDecString(settingString)) {
            try {
                return Integer.parseInt(settingString);
            }
            catch (NumberFormatException exception) {
                CUtilityFunctions.logException(exception);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Pair<Map<String, String>, ZyGraphViewSettings> createSettings(INaviView view) throws CouldntLoadDataException {
        ZyGraphViewSettings defaultSettings = view.getGraphType() == GraphType.CALLGRAPH ? ConfigManager.instance().getDefaultCallGraphSettings() : ConfigManager.instance().getDefaultFlowGraphSettings();
        Map<String, String> rawSettings = view.loadSettings();
        ZyGraphViewSettings settings = new ZyGraphViewSettings(defaultSettings);
        settings.getDisplaySettings().setAnimationSpeed(CViewSettingsGenerator.createIntegerSetting(rawSettings, "animation_speed", defaultSettings.getDisplaySettings().getAnimationSpeed()));
        settings.getLayoutSettings().setAutolayoutActivisionThreshold(CViewSettingsGenerator.createIntegerSetting(rawSettings, "autolayout_treshold", defaultSettings.getLayoutSettings().getAutolayoutDeactivationThreshold()));
        settings.getLayoutSettings().setAutomaticLayouting(CViewSettingsGenerator.createBooleanSetting(rawSettings, "automatic_layouting", defaultSettings.getLayoutSettings().getAutomaticLayouting()));
        settings.getLayoutSettings().getCircularSettings().setStyle(CViewSettingsGenerator.createEnumerationSetting(rawSettings, "circular_layout_style", defaultSettings.getLayoutSettings().getCircularSettings().getStyle(), new IParser<CircularStyle>(){

            @Override
            public CircularStyle parse(int value) {
                return CircularStyle.parseInt(value);
            }
        }));
        settings.getEdgeSettings().setDisplayMultipleEdgesAsOne(CViewSettingsGenerator.createBooleanSetting(rawSettings, "multiple_edges_as_one", defaultSettings.getEdgeSettings().getDisplayMultipleEdgesAsOne()));
        settings.getDisplaySettings().setFunctionNodeInformation(CViewSettingsGenerator.createBooleanSetting(rawSettings, "function_node_information", defaultSettings.getDisplaySettings().getFunctionNodeInformation()));
        settings.getDisplaySettings().setGradientBackground(CViewSettingsGenerator.createBooleanSetting(rawSettings, "gradient_background", defaultSettings.getDisplaySettings().getGradientBackground()));
        settings.getLayoutSettings().getHierarchicalSettings().setStyle(CViewSettingsGenerator.createEnumerationSetting(rawSettings, "hierarchic_layout_style", defaultSettings.getLayoutSettings().getHierarchicalSettings().getStyle(), new IParser<HierarchicStyle>(){

            @Override
            public HierarchicStyle parse(int value) {
                return HierarchicStyle.parseInt(value);
            }
        }));
        settings.getLayoutSettings().setAnimateLayout(CViewSettingsGenerator.createBooleanSetting(rawSettings, "layout_animation", defaultSettings.getLayoutSettings().getAnimateLayout()));
        settings.getLayoutSettings().setLayoutCalculationTimeWarningThreshold(CViewSettingsGenerator.createIntegerSetting(rawSettings, "layout_calculation_treshold", defaultSettings.getLayoutSettings().getLayoutCalculationTimeWarningThreshold()));
        settings.getLayoutSettings().getCircularSettings().setMinimumNodeDistance(CViewSettingsGenerator.createIntegerSetting(rawSettings, "minimum_circular_node_distance", defaultSettings.getLayoutSettings().getCircularSettings().getMinimumNodeDistance()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumEdgeDistance(CViewSettingsGenerator.createIntegerSetting(rawSettings, "minimum_hierarchic_edge_distance", defaultSettings.getLayoutSettings().getHierarchicalSettings().getMinimumEdgeDistance()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumLayerDistance(CViewSettingsGenerator.createIntegerSetting(rawSettings, "minimum_hierarchic_layer_distance", defaultSettings.getLayoutSettings().getHierarchicalSettings().getMinimumLayerDistance()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumNodeDistance(CViewSettingsGenerator.createIntegerSetting(rawSettings, "minimum_hierarchic_node_distance", defaultSettings.getLayoutSettings().getHierarchicalSettings().getMinimumNodeDistance()));
        settings.getLayoutSettings().getOrthogonalSettings().setMinimumNodeDistance(CViewSettingsGenerator.createIntegerSetting(rawSettings, "minimum_orthogonal_node_distance", defaultSettings.getLayoutSettings().getOrthogonalSettings().getMinimumNodeDistance()));
        settings.getMouseSettings().setMousewheelAction(CViewSettingsGenerator.createEnumerationSetting(rawSettings, "mousewheel_action", defaultSettings.getMouseSettings().getMouseWheelAction(), new IParser<MouseWheelAction>(){

            @Override
            public MouseWheelAction parse(int value) throws ParseException {
                return MouseWheelAction.parseInt(value);
            }
        }));
        settings.getLayoutSettings().getOrthogonalSettings().setStyle(CViewSettingsGenerator.createEnumerationSetting(rawSettings, "orthogonal_layout_style", defaultSettings.getLayoutSettings().getOrthogonalSettings().getStyle(), new IParser<OrthogonalStyle>(){

            @Override
            public OrthogonalStyle parse(int value) {
                return OrthogonalStyle.parseInt(value);
            }
        }));
        settings.getLayoutSettings().getOrthogonalSettings().setOrientation(CViewSettingsGenerator.createEnumerationSetting(rawSettings, "orthogonal_orientation", defaultSettings.getLayoutSettings().getOrthogonalSettings().getOrientation(), new IParser<OrthogonalOrientation>(){

            @Override
            public OrthogonalOrientation parse(int value) {
                return OrthogonalOrientation.parseInt(value);
            }
        }));
        settings.getProximitySettings().setProximityBrowsing(CViewSettingsGenerator.createBooleanSetting(rawSettings, "proximity_browsing", defaultSettings.getProximitySettings().getProximityBrowsing()));
        settings.getProximitySettings().setProximityBrowsingActivationThreshold(CViewSettingsGenerator.createIntegerSetting(rawSettings, "proximity_browing_threshold", defaultSettings.getProximitySettings().getProximityBrowsingActivationThreshold()));
        settings.getProximitySettings().setProximityBrowsingChildren(CViewSettingsGenerator.createIntegerSetting(rawSettings, "proximity_browing_children", defaultSettings.getProximitySettings().getProximityBrowsingChildren()));
        settings.getProximitySettings().setProximityBrowsingFrozen(CViewSettingsGenerator.createBooleanSetting(rawSettings, "proximity_browing_frozen", defaultSettings.getProximitySettings().getProximityBrowsingFrozen()));
        settings.getProximitySettings().setProximityBrowsingPreview(CViewSettingsGenerator.createBooleanSetting(rawSettings, "proximity_browing_preview", defaultSettings.getProximitySettings().getProximityBrowsingPreview()));
        settings.getProximitySettings().setProximityBrowsingParents(CViewSettingsGenerator.createIntegerSetting(rawSettings, "proximity_browing_parents", defaultSettings.getProximitySettings().getProximityBrowsingParents()));
        settings.getMouseSettings().setScrollSensitivity(CViewSettingsGenerator.createIntegerSetting(rawSettings, "scroll_sensibility", defaultSettings.getMouseSettings().getScrollSensitivity()));
        settings.getSearchSettings().setSearchCaseSensitive(CViewSettingsGenerator.createBooleanSetting(rawSettings, "search_case_sensitive", defaultSettings.getSearchSettings().getSearchCaseSensitive()));
        settings.getSearchSettings().setSearchRegEx(CViewSettingsGenerator.createBooleanSetting(rawSettings, "search_regex", defaultSettings.getSearchSettings().getSearchRegEx()));
        settings.getSearchSettings().setSearchSelectedNodesOnly(CViewSettingsGenerator.createBooleanSetting(rawSettings, "search_selected_only", defaultSettings.getSearchSettings().getSearchSelectedNodesOnly()));
        settings.getSearchSettings().setSearchVisibleNodesOnly(CViewSettingsGenerator.createBooleanSetting(rawSettings, "search_visible_only", defaultSettings.getSearchSettings().getSearchVisibleNodesOnly()));
        settings.getMouseSettings().setZoomSensitivity(CViewSettingsGenerator.createIntegerSetting(rawSettings, "zoom_sensibility", defaultSettings.getMouseSettings().getZoomSensitivity()));
        settings.getDisplaySettings().setSimplifiedVariableAccess(CViewSettingsGenerator.createBooleanSetting(rawSettings, "simplified_variable_access", defaultSettings.getDisplaySettings().getSimplifiedVariableAccess()));
        return new Pair<Map<String, String>, ZyGraphViewSettings>(rawSettings, settings);
    }
}

