/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CNodeUpdaterInitializer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Loader.CGraphBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.CRegisterHotKeys;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import java.awt.EventQueue;
import java.awt.Toolkit;

public final class CViewLoader {
    private final CGraphWindow window;
    private final IViewContainer container;
    private final INaviView view;
    private CGraphModel graphModel;

    public CViewLoader(CGraphWindow window, IViewContainer container, INaviView view) {
        this.window = window;
        this.container = Preconditions.checkNotNull(container, "Error: Container argument can not be null.");
        this.view = Preconditions.checkNotNull(view, "Error: View argument can not be null.");
    }

    private void workaroundCase874(final ZyGraph graph) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CViewLoader.this.view.getType() == ViewType.Native) {
                    ZoomFunctions.zoomToScreen(graph);
                } else {
                    graph.workAroundCase874();
                }
            }
        });
    }

    private void workArounds(final CGraphPanel panel) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.updateSplitters();
                CViewLoader.this.workaroundCase874(panel.getModel().getGraph());
            }
        });
    }

    public CGraphModel getModel() {
        return this.graphModel;
    }

    public void load() throws CouldntLoadDataException, CPartialLoadException, LoadCancelledException {
        if (!this.view.isLoaded()) {
            this.view.load();
        }
        ZyGraph graph = this.container instanceof CModuleContainer ? CGraphBuilder.buildDnDGraph(this.view, this.container.getModules().get(0).getTypeManager()) : CGraphBuilder.buildGraph(this.view);
        CRegisterHotKeys.register(graph);
        if (this.window == null) {
            CGraphWindow navi = new CGraphWindow();
            CGraphModel model = new CGraphModel(navi, this.container.getDatabase(), this.container, graph);
            CNodeUpdaterInitializer.addUpdaters(model);
            CGraphPanel panel = new CGraphPanel(model);
            navi.addGraph(panel);
            CWindowManager.instance().register(navi);
            navi.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            navi.setVisible(true);
            GuiHelper.applyWindowFix(navi);
            navi.setExtendedState(6);
            this.workArounds(panel);
            this.graphModel = model;
        } else {
            CGraphModel model = new CGraphModel(this.window, this.container.getDatabase(), this.container, graph);
            CNodeUpdaterInitializer.addUpdaters(model);
            CGraphPanel panel = new CGraphPanel(model);
            this.window.addGraph(panel);
            this.workArounds(panel);
            this.window.toFront();
            this.graphModel = model;
        }
    }
}

