/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader.CViewLoader;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.Window;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public final class CGraphOpener {
    private CGraphOpener() {
    }

    public static void showGraph(final IViewContainer container, final INaviView view, final CGraphWindow window, final Window parent) {
        CWindowManager.instance().bringViewToFront(view);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CViewLoader viewLoader = new CViewLoader(window, container, view);
                CViewLoadOperation operation = new CViewLoadOperation(view);
                try {
                    if (!CWindowManager.instance().isOpen(view)) {
                        viewLoader.load();
                    }
                }
                catch (CPartialLoadException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = exception.getMessage();
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be opened because not all required modules are loaded.", view.getName()), new String[0], new String[]{"You have to load all necessary modules before opening this view."});
                    NaviErrorDialog.show(parent, innerMessage, innerDescription, exception);
                }
                catch (Exception exception) {
                    String innerMessage = "E00122: View could not be opened";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be opened.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view can not be opened because not all necessary data was loaded from the database."});
                    NaviErrorDialog.show(parent, "E00122: View could not be opened", innerDescription, exception);
                }
                finally {
                    operation.stop();
                }
            }
        }.start();
    }

    private static Callable<Boolean> generateViewLoader(final INaviView view, final IViewContainer container, final CGraphWindow window, final Window parent) {
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                CViewLoader viewLoader = new CViewLoader(window, container, view);
                CViewLoadOperation operation = new CViewLoadOperation(view);
                try {
                    if (!view.isLoaded()) {
                        viewLoader.load();
                    }
                    Boolean bl2 = true;
                    return bl2;
                }
                catch (CPartialLoadException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = exception.getMessage();
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be opened because not all required modules are loaded.", view.getName()), new String[0], new String[]{"You have to load all necessary modules before opening this view."});
                    NaviErrorDialog.show(parent, innerMessage, innerDescription, exception);
                    Boolean bl3 = false;
                    return bl3;
                }
                catch (Exception exception) {
                    String innerMessage = "E00122: View could not be opened";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be opened.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view can not be opened because not all necessary data was loaded from the database."});
                    NaviErrorDialog.show(parent, "E00122: View could not be opened", innerDescription, exception);
                    Boolean bl4 = false;
                    return bl4;
                }
                finally {
                    operation.stop();
                }
            }
        };
    }

    public static void showGraphAndPerformCallBack(IViewContainer container, INaviView view, CGraphWindow window, Window parent, FutureCallback<Boolean> callBack) {
        CWindowManager.instance().bringViewToFront(view);
        ListeningExecutorService service = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(10));
        ListenableFuture<Boolean> loader = service.submit(CGraphOpener.generateViewLoader(view, container, window, parent));
        Futures.addCallback(loader, callBack);
    }

    private static final class CViewLoadOperation
    implements IProgressOperation {
        private final INaviView m_view;
        private final CProgressPanel m_progressBar;

        public CViewLoadOperation(INaviView view) {
            this.m_view = view;
            this.m_progressBar = new CProgressPanel(String.format("Loading view '%s'", view.getName()), true, false);
            this.m_progressBar.start();
            CGlobalProgressManager.instance().add(this);
        }

        @Override
        public String getDescription() {
            return String.format("Loading view '%s'", this.m_view.getName());
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressBar;
        }

        public void stop() {
            this.m_progressBar.stop();
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

