/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.Loaders.CViewOpener;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.REIL.CReilViewCreator;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;

public final class CReilConverter {
    private CReilConverter() {
    }

    public static void showReilGraph(CGraphWindow parent, IViewContainer viewContainer, INaviModule module, INaviView view) {
        ReilCreationThread thread2 = new ReilCreationThread(module, view);
        CProgressDialog.showEndless(parent, "Creating REIL graph ...", thread2);
        Exception exception = thread2.getException();
        if (exception != null) {
            if (exception instanceof CouldntSaveDataException) {
                CUtilityFunctions.logException(exception);
            } else {
                CUtilityFunctions.logException(exception);
                String innerMessage = "E00111: Could not translate view to REIL";
                String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not create the REIL code of view '%s'.", view.getName()), new String[]{"An error occurred in the REIL translator code."}, new String[]{"This is an internal error which you can not fix yourself. Please report the bug to the zynamics support team."});
                NaviErrorDialog.show(parent, "E00111: Could not translate view to REIL", innerDescription);
            }
            return;
        }
        CViewOpener.showView(parent, viewContainer, thread2.getReilView(), parent);
    }

    private static class ReilCreationThread
    extends CEndlessHelperThread {
        private final INaviModule m_module;
        private final INaviView m_view;
        private INaviView m_reilView;

        public ReilCreationThread(INaviModule module, INaviView view) {
            this.m_module = module;
            this.m_view = view;
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            this.m_reilView = CReilViewCreator.create(this.m_module, this.m_view);
            this.m_reilView.getConfiguration().setName(String.format("REIL View of '%s'", this.m_view.getName()));
        }

        public INaviView getReilView() {
            return this.m_reilView;
        }
    }
}

