/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.Color;

public final class CNodeHoverer {
    private ZyLineContent m_lastHoveredLine;

    private static boolean setHoveredLine(ZyLabelContent content, ZyLineContent lineContent, Color color) {
        boolean update = false;
        for (ZyLineContent line : content) {
            if (line.equals(lineContent)) {
                update |= line.setHighlighting(1, color);
                continue;
            }
            update |= line.clearHighlighting(1);
        }
        return update;
    }

    public boolean clear(NaviNode node) {
        IZyNodeRealizer realizer = node.getRealizer();
        boolean update = false;
        for (ZyLineContent line : realizer.getNodeContent()) {
            update |= line.clearHighlighting(1);
        }
        this.m_lastHoveredLine = null;
        return update;
    }

    public void nodeHovered(NaviNode node, double y2) {
        if (node.getRawNode() instanceof CGroupNode) {
            return;
        }
        double yPos = y2 - node.getY();
        IZyNodeRealizer realizer = node.getRealizer();
        int row = node.positionToRow(yPos);
        if (row == -1) {
            if (this.m_lastHoveredLine != null) {
                this.m_lastHoveredLine.clearHighlighting(1);
                this.m_lastHoveredLine = null;
            }
            return;
        }
        ZyLabelContent content = realizer.getNodeContent();
        ZyLineContent hoveredLine = content.getLineContent(row);
        if (hoveredLine.equals(this.m_lastHoveredLine)) {
            return;
        }
        CNodeHoverer.setHoveredLine(content, hoveredLine, realizer.isSelected() ? realizer.getFillColor().darker().darker() : realizer.getFillColor().darker());
        if (this.m_lastHoveredLine != null) {
            this.m_lastHoveredLine.clearHighlighting(1);
        }
        this.m_lastHoveredLine = hoveredLine;
    }
}

