/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.ZyGraph.Filter.CInvisibleNodeFilter;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.gui.zygraph.functions.SelectionFunctions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.SelectableGraph;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import java.util.List;

public final class CGraphSelecter {
    private CGraphSelecter() {
    }

    public static void invertSelection(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01741: Graph argument can not be null");
        SelectionFunctions.invertSelection(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            graph.selectNodes(GraphHelpers.filter(graph, new CInvisibleNodeFilter()), false);
        }
    }

    public static void selectChildrenOfSelection(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01935: Graph argument can not be null");
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.selectSuccessorsOfSelection(selectableGraph);
        } else {
            List rawNodes = GraphConverters.convert(graph.getSelectedNodes());
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getSuccessors(rawNodes)), true);
        }
    }

    public static void selectNodesWithFunctionType(ZyGraph graph, final FunctionType type) {
        List<NaviNode> nodes = GraphHelpers.filter(graph, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                return item.getRawNode() instanceof INaviFunctionNode && ((INaviFunctionNode)item.getRawNode()).getFunction().getType().equals((Object)type);
            }
        });
        graph.selectNodes(nodes, true);
    }

    public static void selectNodesWithParentFunction(ZyGraph graph, final INaviFunction function) {
        List<NaviNode> nodes = GraphHelpers.filter(graph, new ICollectionFilter<NaviNode>(){

            @Override
            public boolean qualifies(NaviNode item) {
                try {
                    return item.getRawNode() instanceof INaviCodeNode && ((INaviCodeNode)item.getRawNode()).getParentFunction() == function;
                }
                catch (MaybeNullException e2) {
                    return false;
                }
            }
        });
        graph.selectNodes(nodes, true);
    }

    public static void selectParentsOfSelection(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01742: Graph argument can not be null");
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.selectPredecessorsOfSelection(selectableGraph);
        } else {
            List rawNodes = GraphConverters.convert(graph.getSelectedNodes());
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getPredecessors(rawNodes)), true);
        }
    }

    public static void selectPredecessors(ZyGraph graph, NaviNode node) {
        Preconditions.checkNotNull(graph, "IE01838: Graph argument can not be null");
        Preconditions.checkNotNull(node, "IE01839: Node argument can not be null");
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.selectPredecessors(selectableGraph, node);
        } else {
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getPredecessors(node.getRawNode())), true);
        }
    }

    public static void selectSuccessors(ZyGraph graph, NaviNode node) {
        Preconditions.checkNotNull(graph, "IE01483: Graph argument can not be null");
        Preconditions.checkNotNull(node, "IE01761: Node argument can not be null");
        SelectableGraph<NaviNode> selectableGraph = SelectableGraph.wrap(graph);
        if (graph.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            GraphHelpers.selectSuccessors(selectableGraph, node);
        } else {
            graph.selectNodes(GraphConverters.convert(graph, GraphAlgorithms.getSuccessors(node.getRawNode())), true);
        }
    }
}

