/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import javax.swing.JFrame;

public final class CGraphProximityBrowser {
    private CGraphProximityBrowser() {
    }

    public static void toggleProximityBrowsing(JFrame parent, ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE01750: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01751: Graph argument can not be null");
        if (graph.getSettings().getProximitySettings().getProximityBrowsing()) {
            CProgressDialog.showEndless(parent, "Switching off proximity browsing", new ProximityWaiter(graph));
        } else {
            CProgressDialog.showEndless(parent, "Switching on proximity browsing", new ProximityWaiter(graph));
        }
    }

    private static class ProximityWaiter
    extends CEndlessHelperThread {
        private final ZyGraph m_graph;

        private ProximityWaiter(ZyGraph graph) {
            this.m_graph = graph;
        }

        @Override
        public void runExpensiveCommand() {
            this.m_graph.getSettings().getProximitySettings().setProximityBrowsing(!this.m_graph.getSettings().getProximitySettings().getProximityBrowsing());
        }
    }
}

