/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.LayoutStyle;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessProgressDialog;
import java.awt.Window;
import javax.swing.JFrame;

public final class CGraphLayouter {
    private CGraphLayouter() {
    }

    private static boolean askLayout(JFrame parent, ZyGraph graph) {
        if (graph.visibleNodeCount() >= graph.getSettings().getLayoutSettings().getLayoutCalculationTimeWarningThreshold()) {
            return 0 == CMessageBox.showYesNoQuestion(parent, "Layouting this graph can take a while. Do you want to continue?");
        }
        return true;
    }

    private static void checkArguments(JFrame parent, ZyGraph graph) {
        Preconditions.checkNotNull(parent, "IE01746: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01747: Graph argument can not be null");
    }

    public static void doCircularLayout(JFrame parent, ZyGraph graph) {
        CGraphLayouter.checkArguments(parent, graph);
        if (!CGraphLayouter.askLayout(parent, graph)) {
            return;
        }
        graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.CIRCULAR);
        CGraphLayouter.refreshLayout(parent, graph);
    }

    public static void doHierarchicLayout(JFrame parent, ZyGraph graph) {
        CGraphLayouter.checkArguments(parent, graph);
        if (!CGraphLayouter.askLayout(parent, graph)) {
            return;
        }
        graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.HIERARCHIC);
        CGraphLayouter.refreshLayout(parent, graph);
    }

    public static void doOrthogonalLayout(JFrame parent, ZyGraph graph) {
        CGraphLayouter.checkArguments(parent, graph);
        if (!CGraphLayouter.askLayout(parent, graph)) {
            return;
        }
        graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.ORTHOGONAL);
        CGraphLayouter.refreshLayout(parent, graph);
    }

    public static void refreshLayout(JFrame parent, ZyGraph graph) {
        CGraphLayouter.checkArguments(parent, graph);
        LayoutWaiter waiter = new LayoutWaiter(graph);
        CEndlessProgressDialog dlg = new CEndlessProgressDialog((Window)parent, "BinNavi", "Calculating the new graph layout...", waiter);
        waiter.start();
        dlg.setVisible(true);
    }

    public static void toggleAutomaticLayouting(ZyGraph graph) {
        Preconditions.checkNotNull(graph, "IE01748: Graph argument can not be null");
        graph.getSettings().getLayoutSettings().setAutomaticLayouting(!graph.getSettings().getLayoutSettings().getAutomaticLayouting());
    }

    private static class LayoutWaiter
    extends CEndlessHelperThread {
        private final ZyGraph m_graph;

        private LayoutWaiter(ZyGraph graph) {
            this.m_graph = graph;
        }

        @Override
        public void closeRequested() {
            this.finish();
        }

        @Override
        public void runExpensiveCommand() {
            this.m_graph.doLayout();
        }
    }
}

