/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Generic;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.ICommentAccessor;
import com.google.security.zynamics.zylib.gui.CodeDisplay.BasicCodeDisplayModel;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplay;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class GenericCommentsTableModel
extends BasicCodeDisplayModel {
    private static final BasicCodeDisplayModel.JCodeDisplayColumnDescription[] columns = new BasicCodeDisplayModel.JCodeDisplayColumnDescription[]{new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Username", 20, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Comment", 70, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD)};
    private static final int USER_INDEX = 0;
    private static final int COMMENT_INDEX = 1;
    private final ICommentAccessor commentAccessor;
    private ArrayList<IComment> cachedComments;

    public GenericCommentsTableModel(ICommentAccessor commentAccessor) {
        this.commentAccessor = Preconditions.checkNotNull(commentAccessor);
        this.resetCachedComments();
    }

    private void resetCachedComments() {
        this.cachedComments = this.commentAccessor.getComment() == null ? new ArrayList() : new ArrayList<IComment>(this.commentAccessor.getComment());
    }

    public List<IComment> getComments() {
        return this.cachedComments;
    }

    @Override
    public int getNumberOfRows() {
        return this.cachedComments.size() + 1;
    }

    @Override
    public int getTotalNumberOfLines() {
        int totalNumberOfLines = 0;
        for (IComment comment : this.cachedComments) {
            totalNumberOfLines += comment.getNumberOfCommentLines();
        }
        return totalNumberOfLines + 1;
    }

    @Override
    public boolean hasHeaderRow() {
        return true;
    }

    @Override
    public FormattedCharacterBuffer getHeader(int columnIndex) {
        Preconditions.checkElementIndex(columnIndex, columns.length);
        return columns[columnIndex].getHeader();
    }

    @Override
    public int getTotalWidthInCharacters() {
        int total = 0;
        for (int index = 0; index < columns.length; ++index) {
            total += columns[index].getWidth();
        }
        return total;
    }

    @Override
    public int getNumberOfColumns() {
        return columns.length;
    }

    @Override
    public int getColumnWidthInCharacters(int columnIndex) {
        Preconditions.checkElementIndex(columnIndex, columns.length);
        return columns[columnIndex].getWidth();
    }

    @Override
    public String getColumnName(int columnIndex) {
        Preconditions.checkElementIndex(columnIndex, columns.length);
        return columns[columnIndex].getName();
    }

    @Override
    public int getMaximumLinesForRow(int rowIndex) {
        if (rowIndex == this.cachedComments.size()) {
            return 1;
        }
        if (rowIndex > this.cachedComments.size()) {
            return 0;
        }
        IComment comment = this.cachedComments.get(rowIndex);
        return comment.getNumberOfCommentLines();
    }

    @Override
    public FormattedCharacterBuffer getLineFormatted(int rowIndex, int columnIndex, int lineIndex) {
        Preconditions.checkElementIndex(columnIndex, columns.length);
        BasicCodeDisplayModel.JCodeDisplayColumnDescription column = columns[columnIndex];
        if (rowIndex >= this.cachedComments.size()) {
            switch (columnIndex) {
                case 0: {
                    String username = CodeDisplay.padRight("Your username ...", column.getWidth());
                    return new FormattedCharacterBuffer(username, STANDARD_FONT, column.getDefaultFontColor(), column.getDefaultBackgroundColor());
                }
                case 1: {
                    String comment = CodeDisplay.padRight("Enter new comment ...", column.getWidth());
                    return new FormattedCharacterBuffer(comment, STANDARD_FONT, column.getDefaultFontColor(), column.getDefaultBackgroundColor());
                }
            }
        }
        switch (columnIndex) {
            case 0: {
                String username = "";
                if (lineIndex == 0) {
                    username = this.cachedComments.get(rowIndex).getUser().getUserName();
                }
                username = CodeDisplay.padRight(username, column.getWidth());
                return new FormattedCharacterBuffer(username, STANDARD_FONT, column.getDefaultFontColor(), column.getDefaultBackgroundColor());
            }
            case 1: {
                String commentLine = this.cachedComments.get(rowIndex).getCommentLine(lineIndex);
                commentLine = CodeDisplay.padRight(commentLine, columns[columnIndex].getWidth());
                return new FormattedCharacterBuffer(commentLine, STANDARD_FONT, column.getDefaultFontColor(), column.getDefaultBackgroundColor());
            }
        }
        return null;
    }

    @Override
    public boolean canHaveCaret(CodeDisplayCoordinate coordinate) {
        return coordinate.getColumn() == 1;
    }

    @Override
    public boolean isEditable(CodeDisplayCoordinate coordinate) {
        if (coordinate.getColumn() != 1) {
            return false;
        }
        if (coordinate.getRow() >= this.cachedComments.size()) {
            return true;
        }
        IComment comment = this.cachedComments.get(coordinate.getRow());
        return comment.getNumberOfCommentLines() == 0 || this.commentAccessor.isOwner(comment);
    }

    private static int lineAndIndexToCommentIndex(IComment comment, int lineNumber, int index) {
        String[] lines = comment.getCommentLines();
        if (index > lines[lineNumber].length()) {
            return -1;
        }
        int temporaryIndex = 0;
        for (int line = 0; line < lineNumber; ++line) {
            temporaryIndex += lines[line].length() + 1;
        }
        return temporaryIndex += index;
    }

    private IComment editComment(IComment comment, String newComment) {
        IComment newlySetComment = null;
        try {
            if (newComment.isEmpty()) {
                this.commentAccessor.deleteComment(comment);
            } else {
                newlySetComment = this.commentAccessor.editComment(comment, newComment);
            }
        }
        catch (CouldntDeleteException | CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
        }
        this.resetCachedComments();
        return newlySetComment;
    }

    private IComment deleteCharacterFromComment(IComment comment, int lineNumber, int index) {
        int commentIndex = GenericCommentsTableModel.lineAndIndexToCommentIndex(comment, lineNumber, index);
        String commentString = comment.getComment();
        if (commentIndex == -1) {
            return comment;
        }
        if (commentIndex < commentString.length()) {
            String string2 = String.valueOf(commentString.substring(0, commentIndex));
            String string3 = String.valueOf(commentString.substring(commentIndex + 1));
            String newComment = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            return this.editComment(comment, newComment);
        }
        return this.editComment(comment, commentString.substring(0, commentIndex));
    }

    private IComment handleBackspaceKeyInComment(IComment comment, CodeDisplayCoordinate coordinate) {
        int lineNumber = coordinate.getLine();
        int index = coordinate.getFieldIndex();
        int commentIndex = GenericCommentsTableModel.lineAndIndexToCommentIndex(comment, lineNumber, index);
        if (!(coordinate.getFieldIndex() == 0 && coordinate.getLine() > 0 || coordinate.getFieldIndex() == 0 && coordinate.getLine() == 0)) {
            coordinate.setFieldIndex(Math.max(coordinate.getFieldIndex() - 1, 0));
            if (commentIndex >= 0) {
                return this.deleteCharacterFromComment(comment, coordinate.getLine(), coordinate.getFieldIndex());
            }
        }
        return comment;
    }

    private IComment handleDeleteKeyInComment(IComment comment, CodeDisplayCoordinate coordinate) {
        int line = coordinate.getLine();
        int field = coordinate.getFieldIndex();
        int commentIndex = GenericCommentsTableModel.lineAndIndexToCommentIndex(comment, coordinate.getLine(), coordinate.getFieldIndex());
        if (commentIndex >= 0) {
            return this.deleteCharacterFromComment(comment, line, field);
        }
        StringBuilder newString = new StringBuilder();
        for (int lineCounter = 0; lineCounter < line; ++lineCounter) {
            newString.append(comment.getCommentLine(lineCounter));
            newString.append("\n");
        }
        newString.append(CodeDisplay.padRight(comment.getCommentLine(line), field));
        for (int lineIndex = line + 1; lineIndex < comment.getNumberOfCommentLines(); ++lineIndex) {
            newString.append(comment.getCommentLine(lineIndex));
            newString.append(lineIndex == comment.getNumberOfCommentLines() - 1 ? "" : "\n");
        }
        return this.editComment(comment, newString.toString());
    }

    private IComment handleRegularKeyInComment(IComment comment, CodeDisplayCoordinate coordinate, KeyEvent event) {
        int field;
        int line = coordinate.getLine();
        int commentIndex = GenericCommentsTableModel.lineAndIndexToCommentIndex(comment, line, field = coordinate.getFieldIndex());
        if (commentIndex >= 0) {
            char c2 = event.getKeyChar();
            comment = this.insertStringIntoComment(comment, line, field, new StringBuilder(1).append(c2).toString());
        } else {
            String lineString = comment.getCommentLine(coordinate.getLine());
            String string2 = String.valueOf(CodeDisplay.padRight("", coordinate.getFieldIndex() - lineString.length()));
            char c3 = event.getKeyChar();
            String paddingAndKey = new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append(c3).toString();
            comment = this.insertStringIntoComment(comment, coordinate.getLine(), lineString.length(), paddingAndKey);
        }
        return comment;
    }

    private IComment insertStringIntoComment(IComment comment, int lineNumber, int index, String string2) {
        int commentIndex = GenericCommentsTableModel.lineAndIndexToCommentIndex(comment, lineNumber, index);
        if (commentIndex < 0) {
            return null;
        }
        String commentString = comment.getComment();
        String string3 = String.valueOf(commentString.substring(0, commentIndex));
        String string4 = String.valueOf(commentString.substring(commentIndex));
        String newComment = new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string4).length()).append(string3).append(string2).append(string4).toString();
        return this.editComment(comment, newComment);
    }

    @Override
    public void keyPressedOrTyped(CodeDisplayCoordinate coordinate, KeyEvent event) {
        int commentRow = coordinate.getRow();
        IComment comment = null;
        if (commentRow < this.cachedComments.size()) {
            comment = this.cachedComments.get(commentRow);
        }
        if (!this.isEditable(coordinate)) {
            return;
        }
        block1 : switch (event.getKeyCode()) {
            case 0: {
                if (commentRow >= this.cachedComments.size()) {
                    try {
                        this.commentAccessor.appendComment(String.format("%c", Character.valueOf(event.getKeyChar())));
                        coordinate.setFieldIndex(1);
                    }
                    catch (CouldntLoadDataException | CouldntSaveDataException e2) {
                        CUtilityFunctions.logException(e2);
                    }
                    this.resetCachedComments();
                    break;
                }
                switch (event.getKeyChar()) {
                    case '\n': {
                        comment = this.handleRegularKeyInComment(comment, coordinate, event);
                        coordinate.setLine(coordinate.getLine() < comment.getNumberOfCommentLines() - 1 ? coordinate.getLine() + 1 : comment.getNumberOfCommentLines() - 1);
                        coordinate.setFieldIndex(0);
                        break block1;
                    }
                    case '\b': {
                        comment = this.handleBackspaceKeyInComment(comment, coordinate);
                        break block1;
                    }
                    case '\u007f': {
                        comment = this.handleDeleteKeyInComment(comment, coordinate);
                        break block1;
                    }
                }
                comment = this.handleRegularKeyInComment(comment, coordinate, event);
                coordinate.setFieldIndex(coordinate.getFieldIndex() + 1);
                break;
            }
            case 36: {
                coordinate.setFieldIndex(0);
                break;
            }
            case 35: {
                coordinate.setFieldIndex(columns[coordinate.getColumn()].getWidth());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

