/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.FunctionComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.ICommentAccessor;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import java.util.List;

public class CLocalFunctionNodeCommentAccessor
implements ICommentAccessor {
    private final INaviFunctionNode m_functionNode;

    public CLocalFunctionNodeCommentAccessor(INaviFunctionNode functionNode) {
        this.m_functionNode = Preconditions.checkNotNull(functionNode, "IE02671: functionNode argument can not be null");
    }

    @Override
    public List<IComment> appendComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(commentText, "IE02672: commentText argument can not be null");
        return this.m_functionNode.appendLocalFunctionComment(commentText);
    }

    @Override
    public void deleteComment(IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(comment, "IE02673: comment argument can not be null");
        this.m_functionNode.deleteLocalFunctionComment(comment);
    }

    @Override
    public IComment editComment(IComment comment, String newCommentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(comment, "IE02674: comment argument can not be null");
        Preconditions.checkNotNull(newCommentText, "IE02675: newCommentText argument can not be null");
        return this.m_functionNode.editLocalFunctionComment(comment, newCommentText);
    }

    @Override
    public List<IComment> getComment() {
        return this.m_functionNode.getLocalFunctionComment();
    }

    @Override
    public boolean isOwner(IComment comment) {
        return this.m_functionNode.isOwner(comment);
    }
}

