/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CodeNodeComments;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.util.ArrayList;
import java.util.List;

public final class GlobalCodeNodeCommentSynchronizer {
    private GlobalCodeNodeCommentSynchronizer() {
    }

    private static List<INaviCodeNode> collectNodes(INaviView view, INaviCodeNode codeNode) {
        ArrayList<INaviCodeNode> nodelist = new ArrayList<INaviCodeNode>();
        for (INaviViewNode viewnode : view.getGraph().getNodes()) {
            if (!(viewnode instanceof INaviCodeNode)) continue;
            INaviCodeNode node = (INaviCodeNode)viewnode;
            if (!codeNode.getAddress().equals(node.getAddress()) || nodelist.contains(node) || node == codeNode) continue;
            nodelist.add(node);
        }
        return nodelist;
    }

    public static void updateOpenViews(INaviModule module, INaviCodeNode codeNode, ArrayList<IComment> comments) throws CouldntSaveDataException {
        if (module.isLoaded()) {
            ArrayList<INaviCodeNode> nodelist = new ArrayList<INaviCodeNode>();
            for (INaviView view : module.getContent().getViewContainer().getViews()) {
                if (!view.isLoaded()) continue;
                nodelist.addAll(GlobalCodeNodeCommentSynchronizer.collectNodes(view, codeNode));
            }
            List<IComment> codeNodeComments = codeNode.getComments().getGlobalCodeNodeComment();
            for (INaviCodeNode currentCodeNode : nodelist) {
                List<IComment> currentNodeComments = currentCodeNode.getComments().getGlobalCodeNodeComment();
                if (codeNodeComments.equals(currentNodeComments)) continue;
                currentCodeNode.getComments().initializeGlobalCodeNodeComment(comments);
            }
        }
    }
}

