/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CodeNodeComments;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CodeNodeComments.CodeNodeCommentsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.FunctionComments.CFunctionCommentsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InitialTab;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments.CGlobalInstructionCommentsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InstructionComments.LocalInstructionCommentsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.OKButtonPanel;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public final class DialogEditCodeNodeComment
extends JDialog {
    private final INaviCodeNode m_codeNode;
    private final CodeNodeCommentsPanel m_commentsPanel;
    private final CGlobalInstructionCommentsPanel m_globalLineCommentsPanel;
    private final LocalInstructionCommentsPanel m_localLineCommentsPanel;
    private CFunctionCommentsPanel m_functionCommentsPanel = null;

    public DialogEditCodeNodeComment(CGraphModel model, INaviCodeNode node, InitialTab initialTab) {
        super(model.getParent(), "Edit Node Comments", true);
        this.m_codeNode = Preconditions.checkNotNull(node, "IE01701: Node argument can't be null");
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.m_commentsPanel = new CodeNodeCommentsPanel(node);
        this.m_globalLineCommentsPanel = new CGlobalInstructionCommentsPanel(this.m_codeNode, model);
        this.m_localLineCommentsPanel = new LocalInstructionCommentsPanel(this.m_codeNode, model);
        try {
            this.m_functionCommentsPanel = new CFunctionCommentsPanel(node.getParentFunction(), null);
        }
        catch (MaybeNullException exception) {
            CUtilityFunctions.logException(exception);
        }
        this.createGui(initialTab);
    }

    public DialogEditCodeNodeComment(JFrame parent, CGraphModel graphModel, INaviCodeNode node, INaviInstruction instruction) {
        super(parent, "Edit Node Comments", true);
        Preconditions.checkNotNull(parent, "IE01702: Parent argument can't be null");
        this.m_codeNode = Preconditions.checkNotNull(node, "IE01703: Node argument can't be null");
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.m_commentsPanel = new CodeNodeCommentsPanel(node);
        this.m_globalLineCommentsPanel = new CGlobalInstructionCommentsPanel(this.m_codeNode, graphModel);
        this.m_localLineCommentsPanel = new LocalInstructionCommentsPanel(this.m_codeNode, graphModel);
        this.createGui(InitialTab.LocalLineComments);
    }

    private void createGui(InitialTab initialTab) {
        JTabbedPane tab = new JTabbedPane();
        tab.add("Global Line Comments", this.m_globalLineCommentsPanel);
        tab.add("Local Line Comments", this.m_localLineCommentsPanel);
        tab.add("Node Comments", this.m_commentsPanel);
        tab.add("Function Comments", this.m_functionCommentsPanel);
        this.add((Component)tab, "Center");
        this.add((Component)new OKButtonPanel(this), "South");
        this.pack();
        switch (initialTab) {
            case GlobalLineComments: {
                tab.setSelectedIndex(0);
                break;
            }
            case LocalLineComments: {
                tab.setSelectedIndex(1);
                break;
            }
            case LocalNodeComments: {
                tab.setSelectedIndex(2);
                this.m_commentsPanel.focusLocalField();
                break;
            }
            case GlobalNodeComments: {
                tab.setSelectedIndex(2);
                this.m_commentsPanel.focusGlobalField();
                break;
            }
            case FunctionComments: {
                tab.setSelectedIndex(3);
                this.m_functionCommentsPanel.focusGlobalField();
                break;
            }
            default: {
                throw new IllegalStateException("IE00681: Unknown initial tab");
            }
        }
    }
}

