/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Modifiers.CDefaultModifier;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyInstructionBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeComments;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public class CCommentUtilities {
    public static String createInstructionLine(INaviInstruction instruction, CGraphModel graphModel) {
        ZyGraphViewSettings graphSettings = graphModel.getGraph().getSettings();
        BackEndDebuggerProvider provider = graphModel.getDebuggerProvider();
        CDefaultModifier modifier = new CDefaultModifier(graphSettings, provider);
        return ZyInstructionBuilder.buildInstructionLine(instruction, graphSettings, modifier).first();
    }

    public static List<Pair<INaviInstruction, IComment>> getLocalInstructionComments(CCodeNode codeNode) {
        Preconditions.checkNotNull(codeNode, "IE02633: codeNode argument can not be null");
        ArrayList<Pair<INaviInstruction, IComment>> values = new ArrayList<Pair<INaviInstruction, IComment>>();
        CCodeNodeComments currentComments = codeNode.getComments();
        for (INaviInstruction instruction : codeNode.getInstructions()) {
            List<IComment> comments = currentComments.getLocalInstructionComment(instruction);
            if (comments == null || comments.isEmpty()) {
                values.add(new Pair<INaviInstruction, Object>(instruction, null));
                continue;
            }
            for (IComment comment : comments) {
                values.add(new Pair<INaviInstruction, IComment>(instruction, comment));
            }
        }
        return values;
    }
}

