/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import java.util.List;
import java.util.Objects;

public class CComment
implements IComment {
    private final Integer id;
    private final IUser user;
    private final IComment parent;
    private final String comment;
    private final String[] lines;

    public CComment(Integer id, IUser user2, IComment parent, String comment) {
        Preconditions.checkArgument(id == null || id > 0, "Error: id can only be larger then zero or null");
        this.id = id;
        this.user = Preconditions.checkNotNull(user2, "IE02631: user argument can not be null");
        this.parent = parent;
        this.comment = Preconditions.checkNotNull(comment, "IE02632: comment argument can not be null");
        Preconditions.checkArgument(!comment.isEmpty(), "Error: comment must be a non empty string");
        List<String> linesList = Splitter.on('\n').splitToList(comment);
        this.lines = linesList.toArray(new String[linesList.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CComment other = (CComment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.user, other.user) && Objects.equals(this.parent, other.parent) && Objects.equals(this.comment, other.comment);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public IComment getParent() {
        return this.parent;
    }

    @Override
    public IUser getUser() {
        return this.user;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getUser(), this.getParent(), this.getComment());
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public boolean isStored() {
        return this.id != null;
    }

    @Override
    public int getNumberOfCommentLines() {
        return this.lines.length;
    }

    @Override
    public String getCommentLine(int index) {
        if (index >= this.lines.length) {
            return null;
        }
        return this.lines[index];
    }

    @Override
    public String[] getCommentLines() {
        return this.lines;
    }
}

