/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.CNameShortener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphSaver;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CSaveProgress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import javax.swing.JFrame;

public final class CPanelCloser {
    private CPanelCloser() {
    }

    private static boolean closeModifiedGraph(JFrame parent, IGraphPanel panel) {
        ZyGraph graph = panel.getModel().getGraph();
        int result = CMessageBox.showYesNoCancelQuestion(parent, String.format("Do you want to save the view '%s' before closing?", CNameShortener.shorten(graph.getRawView())));
        if (result == 0) {
            if (graph.getRawView().getType() == ViewType.Native) {
                CPanelCloser.saveNativeGraph(parent, panel);
            } else {
                CPanelCloser.saveNonNativeGraph(parent, graph);
            }
        }
        return result == 0 || result == 1;
    }

    private static void saveNativeGraph(JFrame parent, IGraphPanel panel) {
        ZyGraph graph = panel.getModel().getGraph();
        CSaveProgress progress = CGraphSaver.saveAs(parent, graph, panel.getModel().getViewContainer());
        while (!progress.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void saveNonNativeGraph(JFrame parent, ZyGraph graph) {
        CSaveProgress progress = CGraphSaver.save(parent, graph);
        while (!progress.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean closeTab(JFrame parent, IGraphPanel panel) {
        Preconditions.checkNotNull(parent, "IE01630: Parent argument can not be null");
        Preconditions.checkNotNull(panel, "IE01631: Panel argument can not be null");
        ZyGraph graph = panel.getModel().getGraph();
        return graph.getRawView().wasModified() ? CPanelCloser.closeModifiedGraph(parent, panel) : true;
    }
}

