/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CCriteriaDialog;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CCriteriaFactory;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CCriteriumExecuter;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CGraphWindowMenuBar;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.helpers.CNodeColorizer;
import com.google.security.zynamics.binnavi.Gui.Scripting.CScriptingDialog;
import com.google.security.zynamics.binnavi.ZyGraph.helpers.CNodeColorCollector;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CColorChooser;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.HashMap;

public final class CGraphPanelDialogs {
    private final CGraphModel m_model;
    private final CGraphWindowMenuBar m_menuBar;
    private final CScriptingDialog m_scriptingDlg;
    private boolean m_shownScriptingDialogBefore = false;
    private final CCriteriaDialog m_criteriaDlg;

    public CGraphPanelDialogs(CGraphModel model, CGraphWindowMenuBar menuBar) {
        this.m_model = model;
        this.m_menuBar = menuBar;
        CGraphWindow parent = model.getParent();
        ZyGraph graph = model.getGraph();
        String defaultLanguage = ConfigManager.instance().getGeneralSettings().getDefaultScriptingLanguage();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("cg", model.getView2D());
        bindings.put("cf", model.getGraphFrame());
        bindings.put("cdb", model.getApiDatabase());
        this.m_scriptingDlg = new CScriptingDialog((Frame)parent, defaultLanguage, PluginInterface.instance(), bindings);
        this.m_scriptingDlg.setTitle(String.format("%s - %s", this.m_scriptingDlg.getTitle(), graph.getRawView().getName()));
        this.m_criteriaDlg = new CCriteriaDialog(model.getParent(), new CCriteriaFactory(model.getGraph(), model.getView2D(), model.getDatabase().getContent().getNodeTagManager()));
    }

    public void dispose() {
        this.m_scriptingDlg.dispose();
        this.m_criteriaDlg.delete();
    }

    public void selectByCriteria() {
        GuiHelper.centerChildToParent(this.m_model.getParent(), this.m_criteriaDlg, true);
        this.m_criteriaDlg.setVisible(true);
        this.m_criteriaDlg.setVisible(false);
        if (this.m_criteriaDlg.isClosedOk()) {
            CCriteriumTree tree = this.m_criteriaDlg.getCriteriumTree();
            this.m_menuBar.getCriteriumCache().add(tree.createCachedTree());
            CCriteriumExecuter.execute(tree, this.m_model.getGraph());
        }
    }

    public void showColorizeNodesDialog() {
        Color col = CColorChooser.showDialog((Component)this.m_model.getParent(), "Color Nodes", Color.WHITE, CNodeColorCollector.getNodeColors(this.m_model.getGraph()).toArray(new Color[0]));
        if (col != null) {
            CNodeColorizer.colorizeSelectedNodes(this.m_model.getGraph(), col);
        }
    }

    public void showScriptingDialog() {
        if (!this.m_shownScriptingDialogBefore) {
            GuiHelper.centerChildToParent(this.m_model.getParent(), this.m_scriptingDlg, true);
        }
        this.m_shownScriptingDialogBefore = true;
        if (this.m_scriptingDlg.isVisible()) {
            this.m_scriptingDlg.toFront();
        } else {
            this.m_scriptingDlg.setVisible(true);
        }
    }
}

