/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanelDialogs;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanelSettingsSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CPanelCloser;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IViewSwitcher;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CGraphWindowMenuBar;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Bottom.CCombinedBottomPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Center.CCombinedCenterPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IFrontEndDebuggerProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Left.CCombinedLeftPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.PerspectiveType;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Right.CCombinedRightPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Toolbar.CGraphToolBar;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.helpers.CSizeSettingsNormalizer;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CDebuggerPainter;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.CGraphHotkeys;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.CGraphPanelSynchronizer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public final class CGraphPanel
extends JPanel
implements IGraphPanel {
    private static final long serialVersionUID = 1468419960151528961L;
    private final CGraphModel m_model;
    private final CGraphPanelSynchronizer m_graphSynchronizer;
    private CGraphWindowMenuBar m_menuBar;
    private CGraphToolBar m_toolBar;
    private final CCombinedBottomPanel m_bottomPanel;
    private final CCombinedCenterPanel m_centerPanel;
    private final CCombinedRightPanel m_rightPanel;
    private final CCombinedLeftPanel m_leftPanel;
    private JideSplitPane m_graphSplitter;
    private JideSplitPane m_graphTaggingSplitter;
    private final CPerspectiveModel m_viewModel;
    private final CGraphPanelDialogs m_dialogs;

    public CGraphPanel(CGraphModel model) {
        super(new BorderLayout());
        IDebugger debugger;
        Preconditions.checkNotNull(model, "IE01617: Model argument can't be null");
        this.m_model = model;
        this.m_model.setPanel(this);
        this.m_viewModel = new CPerspectiveModel(model);
        CGraphWindow parent = this.m_model.getParent();
        ZyGraph graph = this.m_model.getGraph();
        InternalViewSwitcher viewSwitcher = new InternalViewSwitcher();
        this.m_toolBar = new CGraphToolBar(parent, model.getGraphPanel(), graph, this.m_model.getViewContainer().getModules());
        this.m_menuBar = new CGraphWindowMenuBar(this.m_model, viewSwitcher);
        this.m_graphSynchronizer = new CGraphPanelSynchronizer(this.m_model, this.m_menuBar);
        CDebugPerspectiveModel debugPerspective = (CDebugPerspectiveModel)this.m_viewModel.getModel(PerspectiveType.DebugPerspective);
        this.m_bottomPanel = new CCombinedBottomPanel(model, this.m_graphSynchronizer, this.m_viewModel);
        this.m_centerPanel = new CCombinedCenterPanel(model.getGraph(), debugPerspective);
        this.m_rightPanel = new CCombinedRightPanel(parent, model, this.m_viewModel);
        this.m_leftPanel = new CCombinedLeftPanel(model, this.m_viewModel, this.m_toolBar.getSearchPanel().getSearchField());
        this.createGui();
        this.m_dialogs = new CGraphPanelDialogs(model, this.m_menuBar);
        CGraphHotkeys.registerHotKeys(parent, this, (IFrontEndDebuggerProvider)this.m_viewModel.getModel(PerspectiveType.DebugPerspective), this.m_toolBar.getSearchPanel().getSearchField(), this.m_toolBar.getGotoAddressField());
        for (IDebugger debugger2 : model.getDebuggerProvider().getDebuggers()) {
            if (!debugger2.isConnected()) continue;
            debugPerspective.setActiveDebugger(debugger2);
            viewSwitcher.activateDebugView();
            break;
        }
        if ((debugger = debugPerspective.getCurrentSelectedDebugger()) != null && debugger.isConnected()) {
            for (TargetProcessThread thread2 : debugger.getProcessManager().getThreads()) {
                RelocatedAddress address = thread2.getCurrentAddress();
                if (address == null) continue;
                CDebuggerPainter.updateDebuggerHighlighting(graph, debugger.memoryToFile(address), debugger.getModule(address));
            }
        }
    }

    private void createGui() {
        this.m_graphSplitter = new JideSplitPane(){
            private static final long serialVersionUID = -4363828908016863289L;

            @Override
            public void updateUI() {
            }
        };
        this.m_graphSplitter.setOrientation(0);
        this.m_graphSplitter.addPane(this.m_centerPanel);
        this.m_graphSplitter.addPane(this.m_bottomPanel);
        this.m_graphTaggingSplitter = new JideSplitPane(){
            private static final long serialVersionUID = -9037540212052390552L;

            @Override
            public void updateUI() {
            }
        };
        this.m_graphTaggingSplitter.setOrientation(1);
        this.m_graphTaggingSplitter.addPane(this.m_leftPanel);
        this.m_graphTaggingSplitter.addPane(this.m_graphSplitter);
        this.m_graphTaggingSplitter.addPane(this.m_rightPanel);
        this.m_graphTaggingSplitter.setDoubleBuffered(true);
        this.m_graphTaggingSplitter.setOneTouchExpandable(true);
        this.m_graphTaggingSplitter.setMinimumSize(new Dimension(0, 0));
        this.m_graphSplitter.setDoubleBuffered(true);
        this.m_graphSplitter.setOneTouchExpandable(true);
        this.m_graphSplitter.setMinimumSize(new Dimension(0, 0));
        this.add(this.m_graphTaggingSplitter);
        this.add((Component)this.m_toolBar, "North");
    }

    @Override
    public void close(boolean askSave) {
        if (!askSave || CPanelCloser.closeTab(this.m_model.getParent(), this)) {
            this.m_model.getParent().close(this);
        }
    }

    @Override
    public void dispose() {
        this.m_graphSynchronizer.dispose();
        this.m_bottomPanel.dispose();
        this.m_centerPanel.dispose();
        this.m_model.dispose();
        INaviView view = this.m_model.getGraph().getRawView();
        view.close();
        this.m_menuBar.dipose();
        this.m_toolBar.dispose();
        this.m_menuBar.removeAll();
        this.m_toolBar.removeAll();
        this.m_menuBar = null;
        this.m_toolBar = null;
        this.m_rightPanel.dispose();
        this.m_leftPanel.dispose();
        this.m_dialogs.dispose();
        this.removeAll();
    }

    public CGraphPanelDialogs getDialogs() {
        return this.m_dialogs;
    }

    @Override
    public JMenuBar getMenu() {
        return this.m_menuBar;
    }

    @Override
    public CGraphModel getModel() {
        return this.m_model;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public CTagsTree getTagsTree() {
        return this.m_rightPanel.getTree();
    }

    public CGraphToolBar getToolbar() {
        return this.m_toolBar;
    }

    public CPerspectiveModel getViewModel() {
        return this.m_viewModel;
    }

    public void updateSplitters() {
        GeneralSettingsConfigItem.GraphWindowConfigItem settings = ConfigManager.instance().getGeneralSettings().getGraphWindow();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int leftPanelSize = CSizeSettingsNormalizer.getSize(settings.getSizeLeftPanel(), screenSize.width, 200);
        int rightPanelSize = CSizeSettingsNormalizer.getSize(settings.getSizeRightPanel(), screenSize.width, screenSize.width - 200);
        int bottomPanelSize = CSizeSettingsNormalizer.getSize(settings.getSizeBottomPanel(), screenSize.height, screenSize.height - 400);
        this.m_graphTaggingSplitter.setDividerLocation(0, leftPanelSize);
        this.m_graphTaggingSplitter.setDividerLocation(1, rightPanelSize);
        this.m_graphSplitter.setDividerLocation(0, bottomPanelSize);
        CGraphPanelSettingsSynchronizer.initializeSynchronizer(this.m_graphSplitter, this.m_graphTaggingSplitter);
    }

    private class InternalViewSwitcher
    implements IViewSwitcher {
        private InternalViewSwitcher() {
        }

        @Override
        public void activateDebugView() {
            CGraphPanel.this.m_viewModel.setActiveView(PerspectiveType.DebugPerspective);
        }

        @Override
        public void activateStandardView() {
            CGraphPanel.this.m_viewModel.setActiveView(PerspectiveType.StandardPerspective);
        }
    }
}

