/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.gui.GraphFrame;
import com.google.security.zynamics.binnavi.API.gui.GraphWindow;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Undo.CSelectionHistory;
import com.google.security.zynamics.binnavi.ZyGraph.CDefaultProximityUpdater;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;

public final class CGraphModel
implements IGraphModel {
    private static final int MAX_UNDO_LEVEL = 30;
    private final CGraphWindow m_parent;
    private final IDatabase m_database;
    private final IViewContainer m_viewContainer;
    private final ZyGraph m_graph;
    private final View2D m_view2d;
    private final GraphFrame m_graphFrame;
    private CGraphPanel m_graphPanel;
    private final CSelectionHistory m_history;
    private final CDefaultProximityUpdater m_proximityUpdater;

    public CGraphModel(CGraphWindow parent, IDatabase database, IViewContainer viewContainer, ZyGraph graph) {
        this.m_parent = Preconditions.checkNotNull(parent, "IE01610: Parent argument can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE01611: Database argument can not be null");
        this.m_viewContainer = Preconditions.checkNotNull(viewContainer, "IE01612: View container argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE01613: Graph argument can not be null");
        this.m_history = new CSelectionHistory(this.m_graph, 30);
        this.m_view2d = new View2D(database, viewContainer, graph, PluginInterface.instance());
        this.m_graphFrame = new GraphFrame(new GraphWindow(parent), this.m_view2d, viewContainer.getDebuggerProvider());
        this.m_proximityUpdater = new CDefaultProximityUpdater(parent, this.m_graph);
        this.m_graph.addListener(this.m_proximityUpdater);
    }

    public void dispose() {
        this.m_graph.dispose();
        this.m_proximityUpdater.dispose();
    }

    public Database getApiDatabase() {
        return ObjectFinders.getObject(this.m_database, PluginInterface.instance().getDatabaseManager().getDatabases());
    }

    @Override
    public IDatabase getDatabase() {
        return this.m_database;
    }

    @Override
    public BackEndDebuggerProvider getDebuggerProvider() {
        return this.m_viewContainer.getDebuggerProvider();
    }

    @Override
    public ZyGraph getGraph() {
        return this.m_graph;
    }

    public GraphFrame getGraphFrame() {
        return this.m_graphFrame;
    }

    public CGraphPanel getGraphPanel() {
        return this.m_graphPanel;
    }

    @Override
    public CGraphWindow getParent() {
        return this.m_parent;
    }

    public CSelectionHistory getSelectionHistory() {
        return this.m_history;
    }

    public View2D getView2D() {
        return this.m_view2d;
    }

    @Override
    public IViewContainer getViewContainer() {
        return this.m_viewContainer;
    }

    public void setPanel(CGraphPanel graphPanel) {
        Preconditions.checkArgument(this.m_graphPanel == null, "IE01615: Graph panel can not be set twice");
        this.m_graphPanel = Preconditions.checkNotNull(graphPanel, "IE01614: Graph panel argument can not be null");
    }
}

