/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.viewReferences.InstructionNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeHelpers;
import com.google.security.zynamics.binnavi.disassembly.types.TypeChangedListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainerListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitutionChangedListener;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ViewReferencesTableModel
extends DefaultTreeModel {
    private final Map<BaseType, BaseTypeTreeNode> baseTypeToTreeNode;
    private final HashMultimap<TypeMember, TypeMemberTreeNode> typeMemberToTreeNode;
    private final TypeSubstitutionChangedListener typeSubstitutionChangedListener = new InternalTypeSubstitutionChangedListener();
    private final TypeInstanceContainerListener typeInstanceContainerListener = new InternalTypeInstanceContainerListener();
    private final TypeChangedListener typeChangedListener = new InternalTypeChangedListener();
    private final INaviView view;
    private final INaviViewListener viewListener = new InternalViewListener();
    private final ViewReferenceMultiIndex multiIndex;

    public ViewReferencesTableModel(INaviView view) {
        super(new DefaultMutableTreeNode());
        this.view = Preconditions.checkNotNull(view, "Error: view argument can not be null.");
        this.multiIndex = new ViewReferenceMultiIndex();
        this.baseTypeToTreeNode = Maps.newHashMap();
        this.typeMemberToTreeNode = HashMultimap.create();
        this.collectViewReferences();
        this.initializeListeners();
    }

    private void collectViewReferences() {
        for (CCodeNode node : this.view.getContent().getBasicBlocks()) {
            for (INaviInstruction instruction : node.getInstructions()) {
                for (COperandTree operandTree : instruction.getOperands()) {
                    for (INaviOperandTreeNode operandNode : operandTree.getNodes()) {
                        if (operandNode.getTypeSubstitution() != null) {
                            this.addTypeSubstitutionToTree(operandNode, instruction);
                        }
                        if (operandNode.getTypeInstanceReferences() == null) continue;
                        this.addTypeInstancesToTree(operandNode.getTypeInstanceReferences(), instruction);
                    }
                }
            }
        }
    }

    public TypeSubstitution getTypeSubstitution(InstructionNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null.");
        return this.multiIndex.getTypeSubstitution(node);
    }

    public TypeInstanceReference getTypeInstanceReference(InstructionNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null.");
        return this.multiIndex.getTypeInstanceReference(node);
    }

    private void addTypeSubstitutionToTree(INaviOperandTreeNode operandNode, INaviInstruction instruction) {
        TypeSubstitution typeSubstitution = operandNode.getTypeSubstitution();
        BaseTypeCategory category = typeSubstitution.getBaseType().getCategory();
        if (category == BaseTypeCategory.STRUCT || category == BaseTypeCategory.ARRAY || category == BaseTypeCategory.UNION) {
            this.addCompoundTypeSubstitutionToTree(operandNode, instruction, typeSubstitution);
        } else {
            this.addBaseType(typeSubstitution.getBaseType());
            BaseTypeTreeNode currentNode = this.baseTypeToTreeNode.get(typeSubstitution.getBaseType());
            this.insertNodeInto(this.multiIndex.putTypeSubstitution(typeSubstitution, instruction), currentNode, currentNode.getChildCount());
        }
    }

    private void addCompoundTypeSubstitutionToTree(INaviOperandTreeNode operandNode, INaviInstruction instruction, TypeSubstitution typeSubstitution) {
        long completeOffset = operandNode.hasAddendSibling() ? operandNode.determineAddendValue() * 8L + (long)typeSubstitution.getOffset() : (long)typeSubstitution.getOffset();
        BaseTypeHelpers.WalkResult walkResult = BaseTypeHelpers.findMember(typeSubstitution.getBaseType(), completeOffset);
        if (!walkResult.isValid()) {
            return;
        }
        this.addBaseType(typeSubstitution.getBaseType());
        DefaultMutableTreeNode currentNode = this.baseTypeToTreeNode.get(typeSubstitution.getBaseType());
        for (TypeMember typeMember : walkResult.getPath()) {
            TypeMemberTreeNode nextNode = this.checkTypeMemberNodeExists(typeMember, currentNode);
            if (nextNode == null) {
                nextNode = new TypeMemberTreeNode(typeMember);
                this.typeMemberToTreeNode.put((Object)typeMember, (Object)nextNode);
                this.insertNodeInto(nextNode, currentNode, currentNode.getChildCount());
            }
            currentNode = nextNode;
        }
        this.insertNodeInto(this.multiIndex.putTypeSubstitution(typeSubstitution, instruction), currentNode, currentNode.getChildCount());
    }

    private void addBaseType(BaseType baseType) {
        if (!this.baseTypeToTreeNode.containsKey(baseType)) {
            BaseTypeTreeNode baseTypeNode = new BaseTypeTreeNode(baseType);
            this.baseTypeToTreeNode.put(baseType, baseTypeNode);
            this.insertNodeInto(baseTypeNode, (DefaultMutableTreeNode)this.getRoot(), ((DefaultMutableTreeNode)this.getRoot()).getChildCount());
            this.reload((DefaultMutableTreeNode)this.getRoot());
        }
    }

    private TypeMemberTreeNode checkTypeMemberNodeExists(TypeMember typeMember, DefaultMutableTreeNode currentNode) {
        for (int i2 = 0; i2 < currentNode.getChildCount(); ++i2) {
            if (!(currentNode.getChildAt(i2) instanceof TypeMemberTreeNode) || !((TypeMemberTreeNode)currentNode.getChildAt(i2)).getTypeMember().equals(typeMember)) continue;
            return (TypeMemberTreeNode)currentNode.getChildAt(i2);
        }
        return null;
    }

    private void addTypeInstancesToTree(List<TypeInstanceReference> typeInstanceReferences, INaviInstruction instruction) {
        for (TypeInstanceReference typeInstanceReference : typeInstanceReferences) {
            BaseType baseType = typeInstanceReference.getTypeInstance().getBaseType();
            this.addBaseType(baseType);
            this.insertNodeInto(this.multiIndex.putTypeReference(typeInstanceReference, instruction), this.baseTypeToTreeNode.get(baseType), this.baseTypeToTreeNode.get(baseType).getChildCount());
        }
    }

    private void initializeListeners() {
        this.view.addListener(this.viewListener);
        this.view.getConfiguration().getModule().getTypeManager().addListener(this.typeSubstitutionChangedListener);
        this.view.getConfiguration().getModule().getTypeManager().addListener(this.typeChangedListener);
        this.view.getConfiguration().getModule().getContent().getTypeInstanceContainer().addListener(this.typeInstanceContainerListener);
    }

    public void dispose() {
        this.view.getConfiguration().getModule().getContent().getTypeInstanceContainer().removeListener(this.typeInstanceContainerListener);
        this.view.getConfiguration().getModule().getTypeManager().removeListener(this.typeChangedListener);
        this.view.getConfiguration().getModule().getTypeManager().removeListener(this.typeSubstitutionChangedListener);
        this.view.removeListener(this.viewListener);
    }

    private INaviInstruction findInstruction(IAddress address) {
        for (CCodeNode codeNode : this.view.getBasicBlocks()) {
            for (INaviInstruction instruction : codeNode.getInstructions()) {
                if (!instruction.getAddress().equals(address)) continue;
                return instruction;
            }
        }
        return null;
    }

    private void removeFromTree(DefaultMutableTreeNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null.");
        Preconditions.checkArgument(!node.isRoot(), "Error: node argument can not be the root node.");
        HashSet<DefaultMutableTreeNode> nodesToDelete = Sets.newHashSet();
        nodesToDelete.add(node);
        while (node.getSiblingCount() == 1 && node.getParent() != this.getRoot()) {
            node = (DefaultMutableTreeNode)node.getParent();
            nodesToDelete.add(node);
        }
        for (DefaultMutableTreeNode currentNode : nodesToDelete) {
            this.removeNodeFromParent(currentNode);
            if (currentNode instanceof InstructionNode) {
                this.multiIndex.removeInstructionNode((InstructionNode)currentNode);
            }
            if (currentNode instanceof BaseTypeTreeNode) {
                this.baseTypeToTreeNode.remove(((BaseTypeTreeNode)currentNode).getBaseType());
            }
            if (!(currentNode instanceof TypeMemberTreeNode)) continue;
            this.typeMemberToTreeNode.remove(((TypeMemberTreeNode)currentNode).getTypeMember(), currentNode);
        }
    }

    private class InternalTypeChangedListener
    implements TypeChangedListener {
        private InternalTypeChangedListener() {
        }

        @Override
        public void memberAdded(TypeMember member) {
        }

        @Override
        public void memberDeleted(TypeMember member) {
        }

        @Override
        public void membersMoved(Set<BaseType> affectedTypes) {
        }

        @Override
        public void memberUpdated(TypeMember member) {
            for (TypeMemberTreeNode node : ViewReferencesTableModel.this.typeMemberToTreeNode.get(member)) {
                ViewReferencesTableModel.this.nodeChanged(node);
            }
        }

        @Override
        public void typeAdded(BaseType baseType) {
        }

        @Override
        public void typeDeleted(BaseType deletedType) {
        }

        @Override
        public void typesUpdated(Set<BaseType> baseTypes) {
            for (BaseType baseType : Sets.intersection(ViewReferencesTableModel.this.baseTypeToTreeNode.keySet(), baseTypes)) {
                ViewReferencesTableModel.this.nodeChanged((TreeNode)ViewReferencesTableModel.this.baseTypeToTreeNode.get(baseType));
            }
        }
    }

    private class InternalTypeSubstitutionChangedListener
    implements TypeSubstitutionChangedListener {
        private InternalTypeSubstitutionChangedListener() {
        }

        private void removeSubstitutions(Set<TypeSubstitution> substitutions) {
            for (TypeSubstitution typeSubstitution : ImmutableSet.copyOf(Sets.intersection(ViewReferencesTableModel.this.multiIndex.typeSubstitutions.keySet(), substitutions))) {
                ViewReferencesTableModel.this.removeFromTree(ViewReferencesTableModel.this.multiIndex.getInstructionNode(typeSubstitution));
            }
        }

        private void addSubstitutions(Set<TypeSubstitution> substitutions) {
            for (TypeSubstitution typeSubstitution : substitutions) {
                INaviInstruction instruction = ViewReferencesTableModel.this.findInstruction(typeSubstitution.getAddress());
                if (instruction == null) continue;
                ViewReferencesTableModel.this.addTypeSubstitutionToTree(typeSubstitution.getOperandTreeNode(), instruction);
            }
        }

        @Override
        public void substitutionsDeleted(Set<TypeSubstitution> deletedSubstitutions) {
            this.removeSubstitutions(deletedSubstitutions);
        }

        @Override
        public void substitutionsChanged(Set<TypeSubstitution> changedSubstitutions) {
            this.removeSubstitutions(changedSubstitutions);
            this.addSubstitutions(changedSubstitutions);
        }

        @Override
        public void substitutionsAdded(Set<TypeSubstitution> addedSubstitutions) {
            this.addSubstitutions(addedSubstitutions);
        }
    }

    private class InternalTypeInstanceContainerListener
    implements TypeInstanceContainerListener {
        private InternalTypeInstanceContainerListener() {
        }

        private boolean needsRefresh(TypeInstanceReference reference) {
            return reference.getView() == ViewReferencesTableModel.this.view;
        }

        @Override
        public void addedTypeInstance(TypeInstance instance) {
        }

        @Override
        public void addedTypeInstanceReference(TypeInstanceReference reference) {
            if (this.needsRefresh(reference)) {
                INaviInstruction instruction = ViewReferencesTableModel.this.findInstruction(reference.getAddress());
                ViewReferencesTableModel.this.addTypeInstancesToTree(Lists.newArrayList(reference), instruction);
            }
        }

        @Override
        public void changedTypeInstance(TypeInstance instance) {
            for (TypeInstanceReference reference : ViewReferencesTableModel.this.multiIndex.getTypeInstanceReferences(instance)) {
                ViewReferencesTableModel.this.nodeChanged(ViewReferencesTableModel.this.multiIndex.getInstructionNode(reference));
            }
        }

        @Override
        public void changedTypeInstanceReference(TypeInstanceReference reference) {
            if (this.needsRefresh(reference)) {
                ViewReferencesTableModel.this.nodeChanged(ViewReferencesTableModel.this.multiIndex.getInstructionNode(reference));
            }
        }

        @Override
        public void removedTypeInstance(TypeInstance instance) {
        }

        @Override
        public void removedTypeInstanceReference(TypeInstanceReference reference) {
            if (this.needsRefresh(reference)) {
                ViewReferencesTableModel.this.removeFromTree(ViewReferencesTableModel.this.multiIndex.getInstructionNode(reference));
            }
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void closedView(INaviView view, IDirectedGraph<INaviViewNode, INaviEdge> oldGraph) {
            ViewReferencesTableModel.this.dispose();
        }
    }

    private class ViewReferenceMultiIndex {
        private final BiMap<INaviInstruction, InstructionNode> instructionNodes = HashBiMap.create();
        private final BiMap<TypeInstanceReference, InstructionNode> typeInstanceReferences = HashBiMap.create();
        private final BiMap<TypeSubstitution, InstructionNode> typeSubstitutions = HashBiMap.create();
        private final HashMultimap<TypeInstance, TypeInstanceReference> typeInstances = HashMultimap.create();

        public InstructionNode getInstructionNode(TypeInstanceReference reference) {
            return (InstructionNode)this.typeInstanceReferences.get(reference);
        }

        public InstructionNode getInstructionNode(TypeSubstitution typeSubstitution) {
            return (InstructionNode)this.typeSubstitutions.get(typeSubstitution);
        }

        public InstructionNode putTypeReference(TypeInstanceReference reference, INaviInstruction instruction) {
            InstructionNode node = new InstructionNode(instruction, false);
            this.instructionNodes.put(instruction, node);
            this.typeInstanceReferences.put(reference, node);
            this.typeInstances.put((Object)reference.getTypeInstance(), (Object)reference);
            return node;
        }

        public InstructionNode putTypeSubstitution(TypeSubstitution substitution, INaviInstruction instruction) {
            InstructionNode node = new InstructionNode(instruction, true);
            this.instructionNodes.put(instruction, node);
            this.typeSubstitutions.put(substitution, node);
            return node;
        }

        public void removeInstructionNode(InstructionNode node) {
            this.instructionNodes.inverse().remove(node);
            if (this.typeInstanceReferences.containsValue(node)) {
                TypeInstanceReference reference = (TypeInstanceReference)this.typeInstanceReferences.inverse().remove(node);
                this.typeInstances.remove(reference.getTypeInstance(), reference);
            }
            this.typeSubstitutions.inverse().remove(node);
        }

        public TypeSubstitution getTypeSubstitution(InstructionNode node) {
            return (TypeSubstitution)this.typeSubstitutions.inverse().get(node);
        }

        public TypeInstanceReference getTypeInstanceReference(InstructionNode node) {
            return (TypeInstanceReference)this.typeInstanceReferences.inverse().get(node);
        }

        public Set<TypeInstanceReference> getTypeInstanceReferences(TypeInstance instance) {
            return this.typeInstances.get((Object)instance);
        }
    }
}

