/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CViewPruner {
    private CViewPruner() {
    }

    private static void convertEdges(INaviView view, INaviView prunedView, Map<INaviViewNode, INaviViewNode> nodeMap) {
        HashSet<Pair<INaviViewNode, INaviViewNode>> createdEdges = new HashSet<Pair<INaviViewNode, INaviViewNode>>();
        for (INaviEdge edge : view.getGraph().getEdges()) {
            Set<EdgeResult> sources = CViewPruner.getSources(edge, nodeMap, new HashSet<INaviEdge>());
            Set<EdgeResult> targets = CViewPruner.getTargets(edge, nodeMap, new HashSet<INaviEdge>());
            for (EdgeResult source : sources) {
                for (EdgeResult target : targets) {
                    Pair<INaviViewNode, INaviViewNode> edgePair = new Pair<INaviViewNode, INaviViewNode>(source.m_node, target.m_node);
                    if (createdEdges.contains(edgePair)) continue;
                    prunedView.getContent().createEdge(source.m_node, target.m_node, source.m_type);
                    createdEdges.add(edgePair);
                }
            }
        }
    }

    private static Map<INaviViewNode, INaviViewNode> convertNodes(INaviView view, INaviView prunedView, List<INaviInstruction> keptInstructions) {
        HashMap<INaviViewNode, INaviViewNode> nodeMap = new HashMap<INaviViewNode, INaviViewNode>();
        for (INaviViewNode node : view.getGraph().getNodes()) {
            if (node instanceof INaviCodeNode) {
                CCodeNode newNode;
                INaviCodeNode cnode = (INaviCodeNode)node;
                ArrayList newInstructions = Lists.newArrayList(cnode.getInstructions());
                newInstructions.retainAll(keptInstructions);
                if (newInstructions.isEmpty()) continue;
                try {
                    newNode = prunedView.getContent().createCodeNode(cnode.getParentFunction(), newInstructions);
                }
                catch (MaybeNullException e2) {
                    newNode = prunedView.getContent().createCodeNode(null, newInstructions);
                }
                newNode.setBorderColor(node.getBorderColor());
                newNode.setColor(node.getColor());
                nodeMap.put(node, newNode);
                continue;
            }
            if (!(node instanceof INaviFunctionNode)) continue;
            INaviFunction function = ((INaviFunctionNode)node).getFunction();
            CFunctionNode newNode = prunedView.getContent().createFunctionNode(function);
            nodeMap.put(node, newNode);
        }
        return nodeMap;
    }

    private static Set<EdgeResult> getSources(INaviEdge edge, Map<INaviViewNode, INaviViewNode> nodeMap, Set<INaviEdge> visited) {
        INaviViewNode source = (INaviViewNode)edge.getSource();
        visited.add(edge);
        HashSet<EdgeResult> sources = new HashSet<EdgeResult>();
        if (nodeMap.containsKey(source)) {
            sources.add(new EdgeResult(nodeMap.get(source), edge.getType()));
        } else {
            for (INaviEdge incomingEdge : source.getIncomingEdges()) {
                if (visited.contains(incomingEdge)) continue;
                sources.addAll(CViewPruner.getSources(incomingEdge, nodeMap, visited));
            }
        }
        return sources;
    }

    private static Set<EdgeResult> getTargets(INaviEdge edge, Map<INaviViewNode, INaviViewNode> nodeMap, Set<INaviEdge> visited) {
        INaviViewNode target = (INaviViewNode)edge.getTarget();
        visited.add(edge);
        HashSet<EdgeResult> targets = new HashSet<EdgeResult>();
        if (nodeMap.containsKey(target)) {
            targets.add(new EdgeResult(nodeMap.get(target), edge.getType()));
        } else {
            for (INaviEdge outgoingEdge : target.getOutgoingEdges()) {
                if (visited.contains(outgoingEdge)) continue;
                targets.addAll(CViewPruner.getTargets(outgoingEdge, nodeMap, visited));
            }
        }
        return targets;
    }

    public static INaviView prune(IViewContainer container, INaviView view, List<INaviInstruction> keptInstructions) {
        INaviView prunedView = container.createView("Pruned View", "");
        Map<INaviViewNode, INaviViewNode> nodeMap = CViewPruner.convertNodes(view, prunedView, keptInstructions);
        CViewPruner.convertEdges(view, prunedView, nodeMap);
        return prunedView;
    }

    private static class EdgeResult {
        public final INaviViewNode m_node;
        public final EdgeType m_type;

        private EdgeResult(INaviViewNode node, EdgeType type) {
            this.m_node = node;
            this.m_type = type;
        }
    }
}

