/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CResultColumnWrapper;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultContainer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultsTableFiller;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.ITrackingResultsListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public final class CTrackingResultsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1024629687711193824L;
    private static final String[] COLUMN_NAMES = new String[]{"Status", "Address", "Instruction", "Reads", "Updates", "Defines", "Undefines", "Tainted"};
    private final CTrackingResultContainer m_container;
    private final ITrackingResultsListener m_resultsListener = new InternalResultsListener();

    public CTrackingResultsTableModel(CTrackingResultContainer container) {
        this.m_container = Preconditions.checkNotNull(container, "IE01692: Container argument can not be null");
        this.m_container.addListener(this.m_resultsListener);
    }

    public void dispose() {
        this.m_container.removeListener(this.m_resultsListener);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getRowCount() {
        return this.m_container.getResult() == null ? 0 : this.m_container.getResult().getResults().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<CInstructionResult> results = this.m_container.getResult().getResults();
        CInstructionResult result = results.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new CResultColumnWrapper(this.m_container.getResult().getStartInstruction(), this.m_container.getResult().getTrackedRegister(), result);
            }
            case 1: {
                return CTrackingResultsTableFiller.getAddressColumnText(result);
            }
            case 2: {
                return CTrackingResultsTableFiller.getInstructionColumnText(result);
            }
            case 3: {
                return CTrackingResultsTableFiller.getReadsColumnText(result);
            }
            case 4: {
                return CTrackingResultsTableFiller.getUpdatedColumnText(result);
            }
            case 5: {
                return CTrackingResultsTableFiller.getWritesColumnText(result);
            }
            case 6: {
                return CTrackingResultsTableFiller.getUndefinesColumnText(result);
            }
            case 7: {
                return CTrackingResultsTableFiller.getDefinedColumnText(result);
            }
        }
        throw new IllegalStateException("IE01147: Invalid column");
    }

    private class InternalResultsListener
    implements ITrackingResultsListener {
        private InternalResultsListener() {
        }

        @Override
        public void updatedResult(CTrackingResultContainer trackingResultContainer, CTrackingResult result) {
            CTrackingResultsTableModel.this.fireTableDataChanged();
        }
    }
}

