/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CStatusColumnRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultContainer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultsHighlighter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResultsTableModel;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import com.google.security.zynamics.zylib.gui.tables.CMonospaceRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public final class CTrackingResultsTable
extends JTable {
    private static final long serialVersionUID = -1286932901902302435L;
    public static final int STATUS_COLUMN = 0;
    public static final int ADDRESS_COLUMN = 1;
    public static final int INSTRUCTION_COLUMN = 2;
    public static final int READS_COLUMN = 3;
    public static final int UPDATES_COLUMN = 4;
    public static final int DEFINES_COLUMN = 5;
    public static final int UNDEFINES_COLUMN = 6;
    public static final int TAINTED_COLUMN = 7;
    private final CTrackingResultContainer m_container;
    private final CTrackingResultsTableModel m_model;
    private final TableRowSorter<TableModel> m_sorter;

    public CTrackingResultsTable(CTrackingResultContainer container) {
        this.m_container = Preconditions.checkNotNull(container, "IE01691: Container argument can not be null");
        this.m_model = new CTrackingResultsTableModel(container);
        this.setModel(this.m_model);
        this.m_sorter = new TableRowSorter<CTrackingResultsTableModel>(this.m_model);
        this.setRowSorter(this.m_sorter);
        this.m_sorter.setComparator(1, new LexicalComparator());
        this.getColumnModel().getColumn(0).setCellRenderer(new CStatusColumnRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new CMonospaceRenderer());
        InternalSelectionListener listener = new InternalSelectionListener();
        this.getSelectionModel().addListSelectionListener(listener);
        this.addMouseListener(listener);
    }

    private static List<CInstructionResult> getInstructionResults(CTrackingResult result, int[] normalizedRows) {
        ArrayList<CInstructionResult> results = new ArrayList<CInstructionResult>();
        for (int row : normalizedRows) {
            results.add(result.getResults().get(row));
        }
        return results;
    }

    public void dispose() {
        this.m_model.dispose();
    }

    private class InternalSelectionListener
    extends MouseAdapter
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        private int[] normalizeRows(int[] sortedRows) {
            int[] rawRows = new int[sortedRows.length];
            for (int i2 = 0; i2 < sortedRows.length; ++i2) {
                rawRows[i2] = CTrackingResultsTable.this.convertRowIndexToModel(sortedRows[i2]);
            }
            return rawRows;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                int sortedRow = CTrackingResultsTable.this.rowAtPoint(event.getPoint());
                if (sortedRow == -1) {
                    return;
                }
                int row = CTrackingResultsTable.this.convertRowIndexToModel(sortedRow);
                ZyZoomHelpers.zoomToInstruction(CTrackingResultsTable.this.m_container.getGraph(), CTrackingResultsTable.this.m_container.getResult().getResults().get(row).getInstruction());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int[] normalizedRows = this.normalizeRows(CTrackingResultsTable.this.getSelectedRows());
            List instructionResults = CTrackingResultsTable.getInstructionResults(CTrackingResultsTable.this.m_container.getResult(), normalizedRows);
            CTrackingResultsHighlighter.updateHighlighting(CTrackingResultsTable.this.m_container.getGraph(), CTrackingResultsTable.this.m_container.getResult().getStartInstruction(), CTrackingResultsTable.this.m_container.getResult().getTrackedRegister(), instructionResults);
        }
    }
}

