/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.ITrackingResultsListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CTrackingResultContainer {
    private final ZyGraph m_graph;
    private CTrackingResult m_result = null;
    private final ListenerProvider<ITrackingResultsListener> m_listeners = new ListenerProvider();
    private final IViewContainer m_viewContainer;

    public CTrackingResultContainer(IViewContainer viewContainer, ZyGraph graph) {
        this.m_viewContainer = Preconditions.checkNotNull(viewContainer, "IE01683: View container argument can not be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE01684: Graph argument can not be null");
    }

    public void addListener(ITrackingResultsListener listener) {
        this.m_listeners.addListener(listener);
    }

    public ZyGraph getGraph() {
        return this.m_graph;
    }

    public CTrackingResult getResult() {
        return this.m_result;
    }

    public IViewContainer getViewContainer() {
        return this.m_viewContainer;
    }

    public void removeListener(ITrackingResultsListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setResult(CTrackingResult result) {
        this.m_result = Preconditions.checkNotNull(result, "IE01685: Result argument can not be null");
        for (ITrackingResultsListener listener : this.m_listeners) {
            listener.updatedResult(this, result);
        }
    }
}

