/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CInstructionResult;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CRegisterTrackingHelper;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTrackingResult;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.reil.algorithms.mono2.common.MonoReilSolverResult;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterSetLatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTracker;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingOptions;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.Map;

public final class CTracking {
    private CTracking() {
    }

    public static CTrackingResult track(INaviView view, INaviInstruction startInstruction, String trackedRegister, RegisterTrackingOptions options) throws InternalTranslationException {
        Preconditions.checkNotNull(view, "IE01660: View argument can not be null");
        Preconditions.checkNotNull(startInstruction, "IE01661: Start instruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "IE01662: Register argument can not be null");
        MonoReilSolverResult<RegisterSetLatticeElement> result = RegisterTracker.track(view.getContent().getReilCode(), startInstruction, trackedRegister, options);
        Map<IAddress, INaviInstruction> instructionMap = CRegisterTrackingHelper.getInstructionMap(view);
        ArrayList<CInstructionResult> instructionResultList = new ArrayList<CInstructionResult>();
        Map<IAddress, RegisterSetLatticeElement> perInstructionElement = result.generateAddressToStateMapping(startInstruction, options.trackIncoming());
        for (Map.Entry<IAddress, RegisterSetLatticeElement> addressToStateMapEntry : perInstructionElement.entrySet()) {
            RegisterSetLatticeElement element = addressToStateMapEntry.getValue();
            if (element.getReadRegisters().isEmpty() && element.getNewlyTaintedRegisters().isEmpty() && element.getUntaintedRegisters().isEmpty() && element.getUpdatedRegisters().isEmpty()) continue;
            CAddress concreteAddress = new CAddress(addressToStateMapEntry.getKey().toLong() >> 8);
            instructionResultList.add(new CInstructionResult(instructionMap.get(concreteAddress), addressToStateMapEntry.getValue()));
        }
        return new CTrackingResult(startInstruction, trackedRegister, instructionResultList);
    }
}

