/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterSetLatticeElement;
import java.util.Collection;

public final class CInstructionResult {
    private final INaviInstruction m_instruction;
    private final RegisterSetLatticeElement m_registerSet;

    public CInstructionResult(INaviInstruction instruction, RegisterSetLatticeElement registerSetLatticeElement) {
        this.m_instruction = Preconditions.checkNotNull(instruction, "IE01666: Instruction argument can not be null");
        this.m_registerSet = Preconditions.checkNotNull(registerSetLatticeElement, "IE01667: RegisterSetLatticeElement can not be null");
    }

    public boolean clearsTrackedRegister(String register2) {
        return this.getUndefinedRegisters().contains(register2);
    }

    public boolean defines() {
        return this.getNewlyTaintedRegisters().size() != 0;
    }

    public Collection<String> getDefinedRegisters() {
        return this.m_registerSet.getTaintedRegisters();
    }

    public Collection<String> getInputRegisters() {
        return this.m_registerSet.getReadRegisters();
    }

    public INaviInstruction getInstruction() {
        return this.m_instruction;
    }

    public Collection<String> getNewlyTaintedRegisters() {
        return this.m_registerSet.getNewlyTaintedRegisters();
    }

    public Collection<String> getUndefinedRegisters() {
        return this.m_registerSet.getUntaintedRegisters();
    }

    public Collection<String> getUpdatedRegisters() {
        return this.m_registerSet.getUpdatedRegisters();
    }

    public boolean undefinesAll() {
        return this.getDefinedRegisters().size() == 0;
    }

    public boolean undefinesSome() {
        return this.getUndefinedRegisters().size() != 0 && this.getDefinedRegisters().size() != 0;
    }

    public boolean updates() {
        return this.getUpdatedRegisters().size() != 0;
    }

    public boolean uses() {
        return this.getInputRegisters().size() != 0;
    }
}

