/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CSpecialInstruction;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.List;

public final class CTypeResultsHighlighter {
    private CTypeResultsHighlighter() {
    }

    private static void clearHighlighting(ZyGraph graph) {
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                if (node.getRawNode() instanceof INaviCodeNode) {
                    INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
                    for (INaviInstruction instruction : cnode.getInstructions()) {
                        int line = CCodeNodeHelpers.instructionToLine(cnode, instruction);
                        node.clearHighlighting(1200, line);
                    }
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    private static void highlightCodeNode(INaviCodeNode cnode, CSpecialInstruction instructionResult) {
        INaviInstruction searchInstruction = instructionResult.getInstruction();
        if (!CCodeNodeHelpers.containsAddress(cnode, searchInstruction.getAddress())) {
            return;
        }
        for (INaviInstruction instruction : cnode.getInstructions()) {
            if (searchInstruction != instruction) continue;
            cnode.setInstructionColor(instruction, 1200, instructionResult.getType().getColor());
        }
    }

    private static void highlightInstructions(ZyGraph graph, List<CSpecialInstruction> instructionResults) {
        for (final CSpecialInstruction instructionResult : instructionResults) {
            graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode node) {
                    if (node.getRawNode() instanceof INaviCodeNode) {
                        INaviCodeNode cnode = (INaviCodeNode)node.getRawNode();
                        CTypeResultsHighlighter.highlightCodeNode(cnode, instructionResult);
                    }
                    return IterationMode.CONTINUE;
                }
            });
        }
    }

    public static void updateHighlighting(ZyGraph graph, List<CSpecialInstruction> instructionResults) {
        Preconditions.checkNotNull(graph, "IE01686: Graph argument can not be null");
        Preconditions.checkNotNull(instructionResults, "IE01689: Instruction results argument can not be null");
        CTypeResultsHighlighter.clearHighlighting(graph);
        CTypeResultsHighlighter.highlightInstructions(graph, instructionResults);
    }
}

