/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CResultsTableModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CSpecialInstructionsModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CTypeColumnRenderer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CTypeComparator;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CTypeResultsHighlighter;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.comparators.HexStringComparator;
import com.google.security.zynamics.zylib.gui.tables.CMonospaceRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public final class CResultsTable
extends JTable {
    private static final long serialVersionUID = -3620728872126946791L;
    private final ZyGraph m_graph;
    private final CSpecialInstructionsModel m_model;
    private final CResultsTableModel m_tableModel;

    public CResultsTable(ZyGraph graph, CSpecialInstructionsModel model) {
        this.m_graph = graph;
        this.m_model = model;
        this.m_tableModel = new CResultsTableModel(model);
        this.setModel(this.m_tableModel);
        TableRowSorter<CResultsTableModel> sorter = new TableRowSorter<CResultsTableModel>(this.m_tableModel);
        sorter.setComparator(0, new CTypeComparator());
        sorter.setComparator(1, new HexStringComparator());
        this.setRowSorter(sorter);
        this.getColumnModel().getColumn(0).setCellRenderer(new CTypeColumnRenderer());
        this.getColumnModel().getColumn(2).setCellRenderer(new CMonospaceRenderer());
        InternalSelectionListener listener = new InternalSelectionListener();
        this.getSelectionModel().addListSelectionListener(listener);
        this.addMouseListener(listener);
    }

    public void dispose() {
        this.m_tableModel.dispose();
    }

    private class InternalSelectionListener
    extends MouseAdapter
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                int sortedRow = CResultsTable.this.rowAtPoint(event.getPoint());
                if (sortedRow == -1) {
                    return;
                }
                int row = CResultsTable.this.convertRowIndexToModel(sortedRow);
                ZyZoomHelpers.zoomToInstruction(CResultsTable.this.m_graph, CResultsTable.this.m_model.getInstruction(row).getInstruction());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            CTypeResultsHighlighter.updateHighlighting(CResultsTable.this.m_graph, CResultsTable.this.m_model.getInstructions());
        }
    }
}

