/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter;

import com.google.common.collect.ListMultimap;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CAbstractTypeDescription;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CSpecialInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CReadsDescription
extends CAbstractTypeDescription {
    protected CReadsDescription() {
        super(new Color(126, 255, 36), "Highlights instructions that read memory");
    }

    private boolean isAnyCall(List<INaviInstruction> instructions, Set<INaviInstruction> calls) {
        for (INaviInstruction naviInstruction : instructions) {
            if (!calls.contains(naviInstruction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Memory Reads";
    }

    @Override
    public Collection<CSpecialInstruction> visit(ReilFunction reilCode, ListMultimap<IAddress, INaviInstruction> instructionMap) {
        ArrayList<CSpecialInstruction> instructions = new ArrayList<CSpecialInstruction>();
        HashSet<INaviInstruction> calls = new HashSet<INaviInstruction>();
        for (ReilBlock block : reilCode.getGraph()) {
            for (ReilInstruction reilInstruction : block) {
                if (!ReilHelpers.isFunctionCall(reilInstruction)) continue;
                calls.addAll(instructionMap.get(ReilHelpers.toNativeAddress(reilInstruction.getAddress())));
            }
        }
        for (ReilBlock block : reilCode.getGraph()) {
            for (ReilInstruction reilInstruction : block) {
                List<INaviInstruction> firstInstructions;
                if (!reilInstruction.getMnemonic().equals("ldm") || this.isAnyCall(firstInstructions = instructionMap.get(ReilHelpers.toNativeAddress(reilInstruction.getAddress())), calls)) continue;
                List<INaviInstruction> nativeInstructions = instructionMap.get(ReilHelpers.toNativeAddress(reilInstruction.getAddress()));
                for (INaviInstruction naviInstruction : nativeInstructions) {
                    instructions.add(new CSpecialInstruction(this, naviInstruction));
                }
            }
        }
        return instructions;
    }
}

