/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CSpecialInstruction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CSpecialInstructionsModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.CTypeResultsHighlighter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.ITypeDescription;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.InstructionHighlighter.ITypeDescriptionListener;
import com.google.security.zynamics.binnavi.ZyGraph.INaviGraphListener;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviGraphListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CGraphSynchronizer {
    private final ZyGraph m_graph;
    private final CSpecialInstructionsModel m_model;
    private final ListMultimap<IAddress, INaviInstruction> m_instructionMap = ArrayListMultimap.create();
    private final INaviViewListener m_listener = new InternalViewListener();
    private final ITypeDescriptionListener m_descriptionListener = new InternalDescriptionListener();
    private final INaviGraphListener m_graphListener = new InternalGraphListener();

    public CGraphSynchronizer(ZyGraph graph, CSpecialInstructionsModel model) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE02843: graph argument can not be null");
        this.m_model = Preconditions.checkNotNull(model, "IE02844: model argument can not be null");
        this.updateInstructionMap();
        this.m_model.setInstructions(this.updateInstructions());
        this.m_graph.addListener(this.m_graphListener);
        this.m_graph.getRawView().addListener(this.m_listener);
        for (ITypeDescription description : model.getDescriptions()) {
            description.addListener(this.m_descriptionListener);
        }
    }

    private boolean highlightAny() {
        return CollectionHelpers.any(this.m_model.getDescriptions(), new ICollectionFilter<ITypeDescription>(){

            @Override
            public boolean qualifies(ITypeDescription item) {
                return item.isEnabled();
            }
        });
    }

    private void update() {
        this.updateInstructionMap();
        this.m_model.setInstructions(this.updateInstructions());
        CTypeResultsHighlighter.updateHighlighting(this.m_graph, this.m_model.getInstructions());
    }

    private void updateInstructionMap() {
        this.m_instructionMap.clear();
        for (INaviViewNode node : this.m_graph.getRawView().getGraph()) {
            if (!(node instanceof INaviCodeNode)) continue;
            INaviCodeNode cnode = (INaviCodeNode)node;
            for (INaviInstruction instruction : cnode.getInstructions()) {
                IAddress address = instruction.getAddress();
                this.m_instructionMap.put(address, instruction);
            }
        }
    }

    private List<CSpecialInstruction> updateInstructions() {
        ArrayList<CSpecialInstruction> instructions = new ArrayList<CSpecialInstruction>();
        if (this.highlightAny()) {
            try {
                ReilFunction reilCode = this.m_graph.getRawView().getContent().getReilCode();
                for (ITypeDescription description : this.m_model.getDescriptions()) {
                    if (!description.isEnabled()) continue;
                    instructions.addAll(description.visit(reilCode, this.m_instructionMap));
                }
            }
            catch (InternalTranslationException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
        return instructions;
    }

    public void dispose() {
        this.m_graph.getRawView().removeListener(this.m_listener);
        for (ITypeDescription description : this.m_model.getDescriptions()) {
            description.removeListener(this.m_descriptionListener);
        }
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void addedNode(INaviView view, INaviViewNode node) {
            CGraphSynchronizer.this.update();
        }

        @Override
        public void addedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            CGraphSynchronizer.this.update();
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            CGraphSynchronizer.this.update();
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            CGraphSynchronizer.this.update();
        }

        @Override
        public void savedView(INaviView view) {
            CGraphSynchronizer.this.update();
        }
    }

    private class InternalGraphListener
    extends NaviGraphListenerAdapter {
        private InternalGraphListener() {
        }

        @Override
        public void changedView(INaviView oldView, INaviView newView) {
            oldView.removeListener(CGraphSynchronizer.this.m_listener);
            newView.addListener(CGraphSynchronizer.this.m_listener);
        }
    }

    private class InternalDescriptionListener
    implements ITypeDescriptionListener {
        private InternalDescriptionListener() {
        }

        @Override
        public void changedColor(Color color) {
            CGraphSynchronizer.this.update();
        }

        @Override
        public void changedStatus(boolean enabled) {
            CGraphSynchronizer.this.update();
        }
    }
}

