/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CrossReferences;

import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CrossReferences.CCrossReference;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CrossReferences.CCrossReferencesModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CrossReferences.CCrossReferencesTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CrossReferences.CCrossReferencesTableMenu;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.IGraphPanelExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanelExtender;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public final class CCrossReferencesPanel
extends JPanel
implements IGraphPanelExtension {
    private static final long serialVersionUID = -5050102470539067670L;
    private final CCrossReferencesModel m_tableModel = new CCrossReferencesModel();
    private final JTable m_table = new CCrossReferencesTable(this.m_tableModel);
    private final InternalViewListener m_internalListener = new InternalViewListener();
    private final Map<INaviFunction, Integer> m_nodeCounter = new HashMap<INaviFunction, Integer>();
    private final List<CCrossReference> m_crossReferences = new ArrayList<CCrossReference>();
    private CGraphWindow m_parent;
    private IViewContainer m_viewContainer;

    public CCrossReferencesPanel() {
        super(new BorderLayout());
        this.m_table.setSelectionMode(0);
        this.add(new JScrollPane(this.m_table));
        this.m_table.addMouseListener(new InternalMouseListener());
    }

    private INaviFunction findForwardedFunction(INaviModule module, INaviFunction function) throws MaybeNullException {
        if (module.isLoaded()) {
            for (INaviFunction sourceFunction : module.getContent().getFunctionContainer().getFunctions()) {
                if (sourceFunction.getForwardedFunctionModuleId() != function.getModule().getConfiguration().getId() || !sourceFunction.getForwardedFunctionAddress().equals(function.getAddress())) continue;
                return sourceFunction;
            }
        }
        throw new MaybeNullException();
    }

    private boolean processNewNode(INaviViewNode node) {
        if (node instanceof INaviCodeNode) {
            INaviCodeNode cnode = (INaviCodeNode)node;
            try {
                INaviFunction targetFunction = cnode.getParentFunction();
                if (!this.m_nodeCounter.containsKey(targetFunction)) {
                    this.m_nodeCounter.put(targetFunction, 1);
                    for (INaviModule sourceModule : this.m_viewContainer.getModules()) {
                        if (sourceModule == targetFunction.getModule()) {
                            for (INaviFunction sourceFunction : sourceModule.getContent().getNativeCallgraph().getCallers(targetFunction)) {
                                this.m_crossReferences.add(new CCrossReference(sourceFunction, targetFunction));
                            }
                            continue;
                        }
                        try {
                            INaviFunction forwardedFunction = this.findForwardedFunction(sourceModule, targetFunction);
                            for (INaviFunction sourceFunction : sourceModule.getContent().getNativeCallgraph().getCallers(forwardedFunction)) {
                                this.m_crossReferences.add(new CCrossReference(sourceFunction, targetFunction));
                            }
                        }
                        catch (MaybeNullException maybeNullException) {
                        }
                    }
                    return true;
                }
                this.m_nodeCounter.put(targetFunction, this.m_nodeCounter.get(targetFunction) + 1);
            }
            catch (MaybeNullException maybeNullException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean processRemovedNode(INaviViewNode node) {
        if (node instanceof INaviCodeNode) {
            INaviCodeNode cnode = (INaviCodeNode)node;
            try {
                INaviFunction targetFunction = cnode.getParentFunction();
                if (this.m_nodeCounter.containsKey(targetFunction)) {
                    int newCounter = this.m_nodeCounter.get(targetFunction) - 1;
                    if (newCounter == 0) {
                        this.m_nodeCounter.remove(targetFunction);
                        HashSet<CCrossReference> toDelete = new HashSet<CCrossReference>();
                        for (CCrossReference reference : this.m_crossReferences) {
                            if (reference.getCalledFunction() != targetFunction) continue;
                            toDelete.add(reference);
                        }
                        this.m_crossReferences.removeAll(toDelete);
                        return true;
                    }
                    this.m_nodeCounter.put(targetFunction, newCounter);
                }
            }
            catch (MaybeNullException maybeNullException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void visit(CGraphModel model, IGraphPanelExtender extender) {
        this.m_parent = model.getParent();
        this.m_viewContainer = model.getViewContainer();
        for (INaviViewNode node : model.getGraph().getRawView().getGraph().getNodes()) {
            this.processNewNode(node);
        }
        this.m_tableModel.setCrossReferences(this.m_crossReferences);
        extender.addTab("Calling Functions", this);
        model.getGraph().getRawView().addListener(this.m_internalListener);
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public void addedNode(INaviView view, INaviViewNode node) {
            if (CCrossReferencesPanel.this.processNewNode(node)) {
                CCrossReferencesPanel.this.m_tableModel.setCrossReferences(CCrossReferencesPanel.this.m_crossReferences);
            }
        }

        @Override
        public void deletedNode(INaviView view, INaviViewNode node) {
            if (CCrossReferencesPanel.this.processRemovedNode(node)) {
                CCrossReferencesPanel.this.m_tableModel.setCrossReferences(CCrossReferencesPanel.this.m_crossReferences);
            }
        }

        @Override
        public void deletedNodes(INaviView view, Collection<INaviViewNode> nodes) {
            boolean update = false;
            for (INaviViewNode node : nodes) {
                update |= CCrossReferencesPanel.this.processRemovedNode(node);
            }
            if (update) {
                CCrossReferencesPanel.this.m_tableModel.setCrossReferences(CCrossReferencesPanel.this.m_crossReferences);
            }
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        private void displayPopupMenu(MouseEvent event) {
            int selectedIndex = CCrossReferencesPanel.this.m_table.rowAtPoint(event.getPoint());
            if (selectedIndex != -1) {
                CCrossReference reference = (CCrossReference)CCrossReferencesPanel.this.m_crossReferences.get(selectedIndex);
                CCrossReferencesTableMenu popupMenu = new CCrossReferencesTableMenu(CCrossReferencesPanel.this.m_parent, CCrossReferencesPanel.this.m_viewContainer, reference.getCallingFunction());
                popupMenu.show(CCrossReferencesPanel.this.m_table, event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }
    }
}

