/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphMagnifier;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public final class CActionMagnifyingGlassViewMode
extends AbstractAction {
    private static final long serialVersionUID = -6270887425285667410L;
    private final ZyGraph m_graph;
    private JButton m_button = null;

    public CActionMagnifyingGlassViewMode(ZyGraph graph) {
        super("Toggle magnifying glass");
        this.m_graph = Preconditions.checkNotNull(graph, "IE01252: Graph argument can not be null");
        this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/nomagnifieingglass_hover.jpg")));
        this.putValue("ShortDescription", "Magnifying Glass");
    }

    private void selectButton() {
        this.m_button.setSelected(true);
        this.putValue("Name", "Magnifying Glass");
        this.putValue("ShortDescription", "Disables Magnifying Glass.");
        this.m_button.setSelectedIcon(new ImageIcon(CMain.class.getResource("data/magnifieingglass_up.jpg")));
        this.m_button.setRolloverSelectedIcon(new ImageIcon(CMain.class.getResource("data/magnifieingglass_hover.jpg")));
        this.m_button.setPressedIcon(new ImageIcon(CMain.class.getResource("data/magnifieingglass_down.jpg")));
    }

    private void unselectButton() {
        this.m_button.setSelected(false);
        this.putValue("Name", "Magnifying Glass");
        this.putValue("ShortDescription", "Enables Magnifying Glass.");
        this.m_button.setIcon(new ImageIcon(CMain.class.getResource("data/nomagnifieingglass_up.jpg")));
        this.m_button.setRolloverIcon(new ImageIcon(CMain.class.getResource("data/nomagnifieingglass_hover.jpg")));
        this.m_button.setPressedIcon(new ImageIcon(CMain.class.getResource("data/nomagnifieingglass_down.jpg")));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CGraphMagnifier.toogleMagnifyingGlass(this.m_graph);
        this.updateButton();
    }

    public void setButton(JButton button) {
        this.m_button = Preconditions.checkNotNull(button, "IE01253: Button argument can not be null");
        this.updateButton();
    }

    public void updateButton() {
        if (this.m_graph.getSettings().getDisplaySettings().getMagnifyingGlassMode()) {
            this.selectButton();
        } else {
            this.unselectButton();
        }
    }
}

