/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JHint.JHintIcon;
import com.google.security.zynamics.zylib.gui.sliders.DoubleLabeledSlider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class CSettingsPanelBuilder {
    private static final Border STANDARD_EMPTY_BORDER = new EmptyBorder(2, 2, 2, 2);
    private static final int PREFERRED_WIDTH = 175;
    private static final int PREFERRED_HEIGHT = 25;

    private CSettingsPanelBuilder() {
    }

    private static void addComponent(JPanel panel, Component component, String description, String hint) {
        JPanel settingPanel = new JPanel(new BorderLayout());
        settingPanel.setBorder(STANDARD_EMPTY_BORDER);
        settingPanel.add((Component)new JLabel(description), "Center");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(component, "Center");
        JHintIcon hintPopup = new JHintIcon(hint);
        hintPopup.setBorder(new EmptyBorder(0, 3, 0, 0));
        innerPanel.add((Component)hintPopup, "East");
        settingPanel.add((Component)innerPanel, "East");
        panel.add(settingPanel);
    }

    public static void addComboBox(JPanel panel, JComboBox<String> comboBox, String description, String hint, boolean value) {
        Preconditions.checkNotNull(panel, "IE01592: Panel argument can not be null");
        Preconditions.checkNotNull(comboBox, "IE01593: Combo box argument can not be null");
        Preconditions.checkNotNull(description, "IE01594: Description argument can not be null");
        comboBox.addItem("On");
        comboBox.addItem("Off");
        comboBox.setSelectedItem(value ? "On" : "Off");
        comboBox.setPreferredSize(new Dimension(175, 25));
        CSettingsPanelBuilder.addComponent(panel, comboBox, description, hint);
    }

    public static void addComboBox(JPanel panel, JComboBox<String> comboBox, String description, String hint, String[] values, int selectedOption) {
        Preconditions.checkNotNull(panel, "IE01595: Panel argument can not be null");
        Preconditions.checkNotNull(comboBox, "IE01596: Combo box argument can not be null");
        Preconditions.checkNotNull(description, "IE01597: Description argument can not be null");
        Preconditions.checkNotNull(values, "IE01598: Values argument can not be null");
        for (String string2 : values) {
            comboBox.addItem(string2);
        }
        comboBox.setSelectedIndex(selectedOption);
        comboBox.setPreferredSize(new Dimension(175, 25));
        CSettingsPanelBuilder.addComponent(panel, comboBox, description, hint);
    }

    public static void addDoubleSlider(JPanel panel, DoubleLabeledSlider slider, String description, String hint, int value) {
        Preconditions.checkNotNull(panel, "IE01599: Panel argument can not be null");
        Preconditions.checkNotNull(slider, "IE01600: Slider argument can not be null");
        Preconditions.checkNotNull(description, "IE01601: Description argument can not be null");
        slider.setValue(value);
        slider.setPreferredSize(new Dimension(175, 25));
        CSettingsPanelBuilder.addComponent(panel, slider, description, hint);
    }

    public static void addTextField(JPanel panel, JTextField textField, String description, String hint, String value) {
        Preconditions.checkNotNull(panel, "IE01602: Panel argument can not be null");
        Preconditions.checkNotNull(textField, "IE01603: Text field argument can not be null");
        Preconditions.checkNotNull(description, "IE01604: Description argument can not be null");
        Preconditions.checkNotNull(value, "IE01605: Value argument can not be null");
        textField.setText(value);
        textField.setPreferredSize(new Dimension(175, 25));
        CSettingsPanelBuilder.addComponent(panel, textField, description, hint);
    }
}

