/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalStyle;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.border.TitledBorder;

public final class COrthogonalPanel
extends CAbstractSettingsPanel {
    private final JComboBox<String> m_cbOrthoOrientation = new JComboBox();
    private final JComboBox<String> m_cbOrthoLayoutStyle = new JComboBox();
    private final JFormattedTextField m_tfOrthogonalMinNodeDistance = new JFormattedTextField(new CDecFormatter(6));

    public COrthogonalPanel(ZyGraphViewSettings settings) {
        super(new GridLayout(3, 1));
        Preconditions.checkNotNull(settings, "IE01591: Settings argument can not be null");
        this.setBorder(new TitledBorder("Orthogonal Layout"));
        CSettingsPanelBuilder.addComboBox(this, this.m_cbOrthoOrientation, "Orientation:", "Specifies whether orthogonal graph orientation goes from left to right or from top to bottom.", new String[]{"Vertical", "Horizontal"}, settings.getLayoutSettings().getOrthogonalSettings().getOrientation().ordinal());
        CSettingsPanelBuilder.addComboBox(this, this.m_cbOrthoLayoutStyle, "Layout Style:", "Exact layouting style used when doing orthogonal layouts.", new String[]{"Normal", "Tree"}, settings.getLayoutSettings().getOrthogonalSettings().getStyle().ordinal());
        CSettingsPanelBuilder.addTextField(this, this.m_tfOrthogonalMinNodeDistance, "Minimum Node Distance:", "Minimum distance between nodes in pixels.", String.valueOf(settings.getLayoutSettings().getOrthogonalSettings().getMinimumNodeDistance()));
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        boolean needsLayouting = settings.getLayoutSettings().getOrthogonalSettings().getMinimumNodeDistance() != Integer.valueOf(this.m_tfOrthogonalMinNodeDistance.getText()).intValue() || settings.getLayoutSettings().getOrthogonalSettings().getStyle() != OrthogonalStyle.parseInt(this.m_cbOrthoLayoutStyle.getSelectedIndex()) || settings.getLayoutSettings().getOrthogonalSettings().getOrientation() != OrthogonalOrientation.parseInt(this.m_cbOrthoOrientation.getSelectedIndex());
        settings.getLayoutSettings().getOrthogonalSettings().setMinimumNodeDistance(Integer.valueOf(this.m_tfOrthogonalMinNodeDistance.getText()));
        settings.getLayoutSettings().getOrthogonalSettings().setStyle(OrthogonalStyle.parseInt(this.m_cbOrthoLayoutStyle.getSelectedIndex()));
        settings.getLayoutSettings().getOrthogonalSettings().setOrientation(OrthogonalOrientation.parseInt(this.m_cbOrthoOrientation.getSelectedIndex()));
        return needsLayouting;
    }
}

