/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.sliders.DoubleLabeledSlider;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;

public final class CMiscPanel
extends CAbstractSettingsPanel {
    private final JComboBox<String> layoutAnimationBox = new JComboBox();
    private final JComboBox<String> functionInformationBox = new JComboBox();
    private final DoubleLabeledSlider m_tfAnimationSpeed = new DoubleLabeledSlider("Slow", "Fast", 1, 5);
    private final JComboBox<String> gradientBackgroundBox = new JComboBox();

    public CMiscPanel(ZyGraphViewSettings settings, boolean isCallgraph) {
        super(new GridLayout(3 + (isCallgraph ? 1 : 0), 1));
        Preconditions.checkNotNull(settings, "IE01590: Settings argument can not be null");
        this.setBorder(new TitledBorder("Miscellaneous"));
        CSettingsPanelBuilder.addComboBox(this, this.gradientBackgroundBox, "Gradient Background:", "Toggles between gradient backgrounds and solid white backgrounds in graph windows.", settings.getDisplaySettings().getGradientBackground());
        CSettingsPanelBuilder.addComboBox(this, this.layoutAnimationBox, "Layout Animation:", "If enabled, a small layout animation is shown when graphs are layouted.", settings.getLayoutSettings().getAnimateLayout());
        CSettingsPanelBuilder.addDoubleSlider(this, this.m_tfAnimationSpeed, "Animation Speed:", "Specifies the animation speed if layout operations are animated.", (25 - settings.getDisplaySettings().getAnimationSpeed()) / 5);
        if (isCallgraph) {
            CSettingsPanelBuilder.addComboBox(this, this.functionInformationBox, "Function Information:", "If enabled, statistical information about functions is shown in function nodes.", settings.getDisplaySettings().getFunctionNodeInformation());
        }
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        settings.getLayoutSettings().setAnimateLayout(this.layoutAnimationBox.getSelectedIndex() == 0);
        settings.getDisplaySettings().setAnimationSpeed(25 - 5 * Integer.valueOf(this.m_tfAnimationSpeed.getValue()));
        settings.getDisplaySettings().setGradientBackground(this.gradientBackgroundBox.getSelectedIndex() == 0);
        settings.getDisplaySettings().setFunctionNodeInformation(this.functionInformationBox.getSelectedIndex() == 0);
        return false;
    }
}

