/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicStyle;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.border.TitledBorder;

public final class CHierarchicPanel
extends CAbstractSettingsPanel {
    private final JComboBox<String> m_cbHierarchicOrientation = new JComboBox();
    private final JComboBox<String> m_cbHierarchicEdgeRoutingStyle = new JComboBox();
    private final JFormattedTextField m_tfHierarchicMinLayerDistance = new JFormattedTextField(new CDecFormatter(6));
    private final JFormattedTextField m_tfHierarchicMinNodeDistance = new JFormattedTextField(new CDecFormatter(6));
    private final JFormattedTextField m_tfHierarchicMinEdgeDistance = new JFormattedTextField(new CDecFormatter(6));
    private final JFormattedTextField m_tfHierarchicMinNodeEdgeDistance = new JFormattedTextField(new CDecFormatter(6));

    public CHierarchicPanel(ZyGraphViewSettings settings) {
        super(new GridLayout(6, 1));
        Preconditions.checkNotNull(settings, "IE01589: Settings argument can not be null");
        this.setBorder(new TitledBorder("Hierarchic Layout"));
        CSettingsPanelBuilder.addComboBox(this, this.m_cbHierarchicOrientation, "Orientation:", "Specifies whether hierarchic graph orientation goes from left to right or from top to bottom.", new String[]{"Vertical", "Horizontal"}, settings.getLayoutSettings().getHierarchicalSettings().getOrientation().ordinal());
        CSettingsPanelBuilder.addComboBox(this, this.m_cbHierarchicEdgeRoutingStyle, "Edge Routing Style:", "Specifies how edges are routed between nodes.", new String[]{"Octlinear Optimal", "Orthogonal Optimal", "Polyline Optimal", "Octlinear Topmost", "Orthogonal Topmost", "Polyline Topmost", "Octlinear Tight Tree", "Orthogonal Tight Tree", "Polyline Tight Tree", "Octlinear BFS", "Orthogonal BFS", "Polyline BFS"}, settings.getLayoutSettings().getHierarchicalSettings().getStyle().ordinal());
        CSettingsPanelBuilder.addTextField(this, this.m_tfHierarchicMinLayerDistance, "Minimum Layer Distance:", "Minimum distance between hierarchic graph layers in pixels.", String.valueOf(settings.getLayoutSettings().getHierarchicalSettings().getMinimumLayerDistance()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfHierarchicMinNodeDistance, "Node to Node Distance:", "Minimum distance between nodes in pixels on the same layer.", String.valueOf(settings.getLayoutSettings().getHierarchicalSettings().getMinimumNodeDistance()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfHierarchicMinEdgeDistance, "Edge to Edge Distance:", "Minimum distance between edges in pixels on the same layer.", String.valueOf(settings.getLayoutSettings().getHierarchicalSettings().getMinimumEdgeDistance()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfHierarchicMinNodeEdgeDistance, "Node to Edge Distance:", "Minimum distance between a node and a non-adjacent edge in the same layer", String.valueOf(settings.getLayoutSettings().getHierarchicalSettings().getMinimumEdgeDistance()));
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        boolean needsLayouting = settings.getLayoutSettings().getHierarchicalSettings().getMinimumLayerDistance() != Integer.valueOf(this.m_tfHierarchicMinLayerDistance.getText()).intValue() || settings.getLayoutSettings().getHierarchicalSettings().getMinimumNodeDistance() != Integer.valueOf(this.m_tfHierarchicMinNodeDistance.getText()).intValue() || settings.getLayoutSettings().getHierarchicalSettings().getMinimumEdgeDistance() != Integer.valueOf(this.m_tfHierarchicMinEdgeDistance.getText()).intValue() || settings.getLayoutSettings().getHierarchicalSettings().getMinimumNodeEdgeDistance() != Integer.valueOf(this.m_tfHierarchicMinNodeEdgeDistance.getText()).intValue() || settings.getLayoutSettings().getHierarchicalSettings().getOrientation() != HierarchicOrientation.parseInt(this.m_cbHierarchicOrientation.getSelectedIndex()) || settings.getLayoutSettings().getHierarchicalSettings().getStyle() != HierarchicStyle.parseInt(this.m_cbHierarchicEdgeRoutingStyle.getSelectedIndex());
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumLayerDistance(Integer.valueOf(this.m_tfHierarchicMinLayerDistance.getText()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumNodeDistance(Integer.valueOf(this.m_tfHierarchicMinNodeDistance.getText()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumEdgeDistance(Integer.valueOf(this.m_tfHierarchicMinEdgeDistance.getText()));
        settings.getLayoutSettings().getHierarchicalSettings().setMinimumNodeEdgeDistance(Integer.valueOf(this.m_tfHierarchicMinNodeEdgeDistance.getText()));
        settings.getLayoutSettings().getHierarchicalSettings().setOrientation(HierarchicOrientation.parseInt(this.m_cbHierarchicOrientation.getSelectedIndex()));
        settings.getLayoutSettings().getHierarchicalSettings().setStyle(HierarchicStyle.parseInt(this.m_cbHierarchicEdgeRoutingStyle.getSelectedIndex()));
        return needsLayouting;
    }
}

