/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAutomatismPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CCircularPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CControlsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CDisassemblyPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CEdgePanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CHierarchicPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CMiscPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.COrthogonalPanel;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public final class CGraphSettingsDialog
extends JDialog {
    private static final long serialVersionUID = 3874204308656158839L;
    private static final int FRAME_WIDTH = 650;
    private static final int FRAME_HEIGHT = 275;
    private final List<CAbstractSettingsPanel> m_settingsPanel = new ArrayList<CAbstractSettingsPanel>();
    private final ZyGraphViewSettings m_settings;
    private boolean m_wasCanceled = true;
    private boolean m_needsLayouting = false;

    public CGraphSettingsDialog(JFrame parent, String topic, ZyGraphViewSettings settings, boolean isDefaultSettingsDialog, boolean isCallgraph) {
        super(parent, topic, true);
        Preconditions.checkNotNull(parent, "IE01586: Parent argument can not be null");
        Preconditions.checkNotNull(topic, "IE01587: Topic argument can not be null");
        Preconditions.checkNotNull(settings, "IE01588: Settings argument can not be null");
        this.m_settings = settings;
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTabbedPane(isDefaultSettingsDialog, isCallgraph), "Center");
        this.add((Component)new CPanelTwoButtons(new InternalListener(), "OK", "Cancel"), "South");
        this.pack();
        GuiHelper.centerChildToParent(parent, this, true);
    }

    private void addTab(JTabbedPane tab, String tabHeader, CAbstractSettingsPanel panel) {
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)panel, "North");
        tab.addTab(tabHeader, new JScrollPane(parentPanel));
        this.m_settingsPanel.add(panel);
    }

    private JTabbedPane createTabbedPane(boolean isDefaultSettingsDialog, boolean isCallgraph) {
        JTabbedPane tab = new JTabbedPane();
        this.addTab(tab, "Automatism", new CAutomatismPanel(this.m_settings, isDefaultSettingsDialog));
        this.addTab(tab, "Edges", new CEdgePanel(this.m_settings));
        this.addTab(tab, "Hierarchic", new CHierarchicPanel(this.m_settings));
        this.addTab(tab, "Orthogonal", new COrthogonalPanel(this.m_settings));
        this.addTab(tab, "Circular", new CCircularPanel(this.m_settings));
        if (!isCallgraph) {
            this.addTab(tab, "Disassembly", new CDisassemblyPanel(this.m_settings));
        }
        this.addTab(tab, "Controls", new CControlsPanel(this.m_settings));
        this.addTab(tab, "Miscellaneous", new CMiscPanel(this.m_settings, !isDefaultSettingsDialog || isCallgraph));
        tab.setPreferredSize(new Dimension(650, 275));
        return tab;
    }

    public boolean needsLayouting() {
        return this.m_needsLayouting;
    }

    public boolean wasCanceled() {
        return this.m_wasCanceled;
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CGraphSettingsDialog.this.m_wasCanceled = false;
                for (CAbstractSettingsPanel panel : CGraphSettingsDialog.this.m_settingsPanel) {
                    CGraphSettingsDialog.this.m_needsLayouting = CGraphSettingsDialog.this.m_needsLayouting | panel.updateSettings(CGraphSettingsDialog.this.m_settings);
                }
            }
            CGraphSettingsDialog.this.dispose();
        }
    }
}

