/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.sliders.DoubleLabeledSlider;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import java.awt.GridLayout;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;

public final class CControlsPanel
extends CAbstractSettingsPanel {
    private final DoubleLabeledSlider m_tfScrollSensitivity = new DoubleLabeledSlider("Low", "High", 1, 5);
    private final DoubleLabeledSlider m_tfZoomSensitivity = new DoubleLabeledSlider("Low", "High", 1, 5);
    private final JComboBox<String> mouseWheelBehaviorBox = new JComboBox();

    public CControlsPanel(ZyGraphViewSettings settings) {
        super(new GridLayout(3, 1));
        this.setBorder(new TitledBorder("Controls"));
        CSettingsPanelBuilder.addComboBox(this, this.mouseWheelBehaviorBox, "Mousewheel Action:", "Specifies whether the mousewheel is used for zooming or scrolling in graph windows.", new String[]{"Zoom", "Scroll"}, settings.getMouseSettings().getMouseWheelAction().ordinal());
        CSettingsPanelBuilder.addDoubleSlider(this, this.m_tfScrollSensitivity, "Scroll Sensitivity:", "Mouse sensitivity during scroll operations.", settings.getMouseSettings().getScrollSensitivity() / 5);
        CSettingsPanelBuilder.addDoubleSlider(this, this.m_tfZoomSensitivity, "Zoom Sensitivity:", "Mouse sensitivity during zoom operations.", settings.getMouseSettings().getZoomSensitivity() / 5);
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        settings.getMouseSettings().setScrollSensitivity(5 * this.m_tfScrollSensitivity.getValue());
        settings.getMouseSettings().setZoomSensitivity(5 * this.m_tfZoomSensitivity.getValue());
        try {
            settings.getMouseSettings().setMousewheelAction(MouseWheelAction.parseInt(this.mouseWheelBehaviorBox.getSelectedIndex()));
        }
        catch (ParseException e2) {
            CUtilityFunctions.logException(e2);
        }
        return false;
    }
}

