/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.CircularStyle;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.border.TitledBorder;

public final class CCircularPanel
extends CAbstractSettingsPanel {
    private final JComboBox<String> m_cbCircularLayoutStyle = new JComboBox();
    private final JFormattedTextField m_tfCircularMinNodeDistance = new JFormattedTextField(new CDecFormatter(6));

    public CCircularPanel(ZyGraphViewSettings settings) {
        super(new GridLayout(2, 1));
        this.setBorder(new TitledBorder("Circular Layout"));
        Preconditions.checkNotNull(settings, "IE01584: Settings argument can not be null");
        CSettingsPanelBuilder.addComboBox(this, this.m_cbCircularLayoutStyle, "Layout Style:", "Exact layouting style used when doing circular layouts.", new String[]{"Compact", "Isolated", "Single Cycle"}, settings.getLayoutSettings().getCircularSettings().getStyle().ordinal());
        CSettingsPanelBuilder.addTextField(this, this.m_tfCircularMinNodeDistance, "Minimum Node Distance:", "Minimum distance between nodes in pixels.", String.valueOf(settings.getLayoutSettings().getCircularSettings().getMinimumNodeDistance()));
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        boolean needsLayouting = Integer.valueOf(this.m_tfCircularMinNodeDistance.getText()).intValue() != settings.getLayoutSettings().getCircularSettings().getMinimumNodeDistance() || CircularStyle.parseInt(this.m_cbCircularLayoutStyle.getSelectedIndex()) != settings.getLayoutSettings().getCircularSettings().getStyle();
        settings.getLayoutSettings().getCircularSettings().setMinimumNodeDistance(Integer.valueOf(this.m_tfCircularMinNodeDistance.getText()));
        settings.getLayoutSettings().getCircularSettings().setStyle(CircularStyle.parseInt(this.m_cbCircularLayoutStyle.getSelectedIndex()));
        return needsLayouting;
    }
}

