/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphSettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CAbstractSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphSettings.CSettingsPanelBuilder;
import com.google.security.zynamics.binnavi.ZyGraph.LayoutStyle;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public final class CAutomatismPanel
extends CAbstractSettingsPanel {
    private static final int NUMBER_OF_ROWS_INITIAL = 7;
    private static final int NUMBER_OF_ROWS = 6;
    private final JComboBox<String> m_cbProximityBrowsing = new JComboBox();
    private final JComboBox<String> m_cbAutolayout = new JComboBox();
    private final JComboBox<String> m_cbDefaultLayoutStyle = new JComboBox();
    private final JFormattedTextField m_tfProximityBrowsingActivationThres = new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(6)));
    private final JFormattedTextField m_tfAutolayoutDeactivationThres = new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(6)));
    private final JFormattedTextField m_tfLayoutProcessingDurationWarningThres = new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(6)));
    private final JFormattedTextField m_tfVisibilityWarningThres = new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(6)));
    private final boolean m_isDefaultSettingsDialog;

    public CAutomatismPanel(ZyGraphViewSettings settings, boolean isDefaultSettingsDialog) {
        super(new GridLayout(isDefaultSettingsDialog ? 7 : 6, 1));
        Preconditions.checkNotNull(settings, "IE01583: Settings argument can not be null");
        this.m_isDefaultSettingsDialog = isDefaultSettingsDialog;
        this.setBorder(new TitledBorder("Automatism Settings"));
        if (isDefaultSettingsDialog) {
            CSettingsPanelBuilder.addComboBox(this, this.m_cbDefaultLayoutStyle, "Default Layout Style:", "Initial layout style for newly opened graphs", new String[]{"Circular", "Hierarchical", "Orthogonal"}, settings.getLayoutSettings().getDefaultGraphLayout().ordinal());
        }
        CSettingsPanelBuilder.addComboBox(this, this.m_cbAutolayout, "Automatic Layouting:", "If activated, graphs are automatically layouted on relevant events.\nThis is especially useful when proximity browsing is activated.", settings.getLayoutSettings().getAutomaticLayouting());
        CSettingsPanelBuilder.addComboBox(this, this.m_cbProximityBrowsing, "Proximity Browsing:", "If activated, proximity browsing is enabled by default.", settings.getProximitySettings().getProximityBrowsing());
        CSettingsPanelBuilder.addTextField(this, this.m_tfProximityBrowsingActivationThres, "Proximity Browsing Activation Threshold:", "Enables proximity browsing on newly loaded graphs if the graph has more than the specified number of nodes.", String.valueOf(settings.getProximitySettings().getProximityBrowsingActivationThreshold()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfAutolayoutDeactivationThres, "Automatic Layouting Deactivation Threshold:", "Disables automatic layouting if more than the specified number of nodes is visible.", String.valueOf(settings.getLayoutSettings().getAutolayoutDeactivationThreshold()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfLayoutProcessingDurationWarningThres, "Layout Calculation Time Warning Threshold:", "Shows a warning before layouting graphs when more than the specified number of nodes is visible.", String.valueOf(settings.getLayoutSettings().getLayoutCalculationTimeWarningThreshold()));
        CSettingsPanelBuilder.addTextField(this, this.m_tfVisibilityWarningThres, "Visibility Warning Threshold:", "Shows a warning if more than the specified number of graph nodes is made visible in one step.", String.valueOf(settings.getLayoutSettings().getVisibilityWarningTreshold()));
    }

    @Override
    public boolean updateSettings(ZyGraphViewSettings settings) {
        settings.getLayoutSettings().setAutomaticLayouting(this.m_cbAutolayout.getSelectedIndex() == 0);
        settings.getProximitySettings().setProximityBrowsing(this.m_cbProximityBrowsing.getSelectedIndex() == 0);
        if (this.m_isDefaultSettingsDialog) {
            settings.getLayoutSettings().setDefaultGraphLayout(LayoutStyle.parseInt(this.m_cbDefaultLayoutStyle.getSelectedIndex()));
        }
        settings.getProximitySettings().setProximityBrowsingActivationThreshold(Integer.valueOf(this.m_tfProximityBrowsingActivationThres.getText()));
        settings.getLayoutSettings().setAutolayoutActivisionThreshold(Integer.valueOf(this.m_tfAutolayoutDeactivationThres.getText()));
        settings.getLayoutSettings().setLayoutCalculationTimeWarningThreshold(Integer.valueOf(this.m_tfLayoutProcessingDurationWarningThres.getText()));
        settings.getLayoutSettings().setVisibilityWarningThreshold(Integer.valueOf(this.m_tfVisibilityWarningThres.getText()));
        return false;
    }
}

