/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.ConcreteTree.IFilterExpression;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.Wrappers.CViewWrapper;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.FilterExpressions.Wrappers.INamedElement;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;

public final class CNameDescriptionFilterExpression<T extends INamedElement>
implements IFilterExpression<T> {
    private final String m_text;
    private final IViewContainer m_module;

    public CNameDescriptionFilterExpression(String text2, IViewContainer module) {
        this.m_text = Preconditions.checkNotNull(text2, "IE02808: text argument can not be null");
        this.m_module = module;
    }

    private boolean checkAddress(INaviView view) {
        if (this.m_module == null) {
            return false;
        }
        INaviFunction function = this.m_module.getFunction(view);
        if (function == null) {
            return false;
        }
        return function.getAddress().toString().toLowerCase().contains(this.m_text.toLowerCase());
    }

    @Override
    public boolean evaluate(T element) {
        if (element.getDescription() != null) {
            return element.getName().toLowerCase().contains(this.m_text.toLowerCase()) || element.getDescription().toLowerCase().contains(this.m_text.toLowerCase()) || element instanceof CViewWrapper && this.checkAddress(((CViewWrapper)element).unwrap());
        }
        return element.getName().toLowerCase().contains(this.m_text.toLowerCase()) || element instanceof CViewWrapper && this.checkAddress(((CViewWrapper)element).unwrap());
    }
}

